/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalSTSupport;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.nativeimage.ImageSingletons;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public class VMThreadLocalSTHolderNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<VMThreadLocalSTHolderNode> TYPE = NodeClass.create(VMThreadLocalSTHolderNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;

    public VMThreadLocalSTHolderNode(VMThreadLocalInfo threadLocalInfo) {
        super(TYPE, StampFactory.objectNonNull());
        this.threadLocalInfo = threadLocalInfo;
    }

    public void generate(NodeLIRBuilderTool gen) {
        Object[] holder = this.threadLocalInfo.isObject ? ((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).objectThreadLocals : (Object[])((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).primitiveThreadLocals;
        LIRKind kind = gen.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        gen.setResult((ValueNode)this, (Value)gen.getLIRGeneratorTool().emitLoadConstant((ValueKind)kind, (Constant)SubstrateObjectConstant.forObject(holder)));
    }
}

