/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.graal.word.DynamicHubAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedType;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.ClassIsAssignableFromNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.InstanceOfSnippetsTemplates;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class TypeSnippets
extends SubstrateTemplates
implements Snippets {
    final RuntimeConfiguration runtimeConfig;
    final SnippetTemplate.SnippetInfo typeEquality = this.snippet(TypeSnippets.class, "typeEqualitySnippet", new LocationIdentity[0]);

    @Snippet
    protected static SubstrateIntrinsics.Any typeEqualitySnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, DynamicHub exactType) {
        if (allowsNull && object == null) {
            return trueValue;
        }
        DynamicHub hubOrNull = SubstrateIntrinsics.loadHubOrNull(object);
        if (hubOrNull != exactType) {
            return falseValue;
        }
        return trueValue;
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfSnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, short start, short range, short slot, @Snippet.ConstantParameter int typeIDSlotOffset) {
        if (object == null) {
            if (allowsNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
        DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
        return TypeSnippets.slotTypeCheck(start, range, slot, typeIDSlotOffset, nonNullHub, trueValue, falseValue);
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfDynamicSnippet(@Snippet.NonNullParameter DynamicHub type, Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, @Snippet.ConstantParameter int typeIDSlotOffset) {
        if (object == null) {
            if (allowsNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
        DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
        return TypeSnippets.slotTypeCheck(type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot(), typeIDSlotOffset, nonNullHub, trueValue, falseValue);
    }

    @Snippet
    protected static SubstrateIntrinsics.Any classIsAssignableFromSnippet(@Snippet.NonNullParameter DynamicHub type, @Snippet.NonNullParameter DynamicHub checkedHub, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter int typeIDSlotOffset) {
        return TypeSnippets.slotTypeCheck(type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot(), typeIDSlotOffset, checkedHub, trueValue, falseValue);
    }

    private static SubstrateIntrinsics.Any slotTypeCheck(short start, short range, short slot, int typeIDSlotOffset, DynamicHub checkedHub, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue) {
        GuardingNode guard;
        int typeCheckStart = Short.toUnsignedInt(start);
        int typeCheckRange = Short.toUnsignedInt(range);
        int typeCheckSlot = Short.toUnsignedInt(slot) * 2;
        int checkedTypeID = Short.toUnsignedInt(DynamicHubAccess.readShort(checkedHub, typeIDSlotOffset + typeCheckSlot, NamedLocationIdentity.FINAL_LOCATION, guard = null));
        if (UnsignedMath.belowThan((int)(checkedTypeID - typeCheckStart), (int)typeCheckRange)) {
            return trueValue;
        }
        return falseValue;
    }

    public static void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new TypeSnippets(options, runtimeConfig, providers, lowerings);
    }

    private TypeSnippets(OptionValues options, RuntimeConfiguration runtimeConfig, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.runtimeConfig = runtimeConfig;
        lowerings.put(InstanceOfNode.class, new InstanceOfLowering(options, providers));
        lowerings.put(InstanceOfDynamicNode.class, new InstanceOfDynamicLowering(options, providers));
        lowerings.put(ClassIsAssignableFromNode.class, new ClassIsAssignableFromLowering(options, providers));
    }

    protected class ClassIsAssignableFromLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        private final SnippetTemplate.SnippetInfo assignableTypeCheck;

        public ClassIsAssignableFromLowering(OptionValues options, Providers providers) {
            super(options, providers);
            this.assignableTypeCheck = this.snippet(TypeSnippets.class, "classIsAssignableFromSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            ClassIsAssignableFromNode node = (ClassIsAssignableFromNode)replacer.instanceOf;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.assignableTypeCheck, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", (Object)node.getThisClass());
            args.add("checkedHub", (Object)node.getOtherClass());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.addConst("typeIDSlotOffset", (Object)TypeSnippets.this.runtimeConfig.getTypeIDSlotsOffset());
            return args;
        }
    }

    protected class InstanceOfDynamicLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        private final SnippetTemplate.SnippetInfo instanceOfDynamic;

        public InstanceOfDynamicLowering(OptionValues options, Providers providers) {
            super(options, providers);
            this.instanceOfDynamic = this.snippet(TypeSnippets.class, "instanceOfDynamicSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            InstanceOfDynamicNode node = (InstanceOfDynamicNode)replacer.instanceOf;
            if (node.isExact()) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.typeEquality, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getObject());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.addConst("allowsNull", (Object)node.allowsNull());
                args.add("exactType", (Object)node.getMirrorOrHub());
                return args;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.instanceOfDynamic, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", (Object)node.getMirrorOrHub());
            args.add("object", (Object)node.getObject());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.addConst("allowsNull", (Object)node.allowsNull());
            args.addConst("typeIDSlotOffset", (Object)TypeSnippets.this.runtimeConfig.getTypeIDSlotsOffset());
            return args;
        }
    }

    protected class InstanceOfLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        private final SnippetTemplate.SnippetInfo instanceOf;

        public InstanceOfLowering(OptionValues options, Providers providers) {
            super(options, providers);
            this.instanceOf = this.snippet(TypeSnippets.class, "instanceOfSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            InstanceOfNode node = (InstanceOfNode)replacer.instanceOf;
            TypeReference typeReference = node.type();
            SharedType type = (SharedType)typeReference.getType();
            DynamicHub hub = type.getHub();
            if (typeReference.isExact()) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.typeEquality, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getValue());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.addConst("allowsNull", (Object)node.allowsNull());
                args.add("exactType", (Object)hub);
                return args;
            }
            assert (type.getSingleImplementor() == null) : "Canonicalization of InstanceOfNode produces exact type for single implementor";
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.instanceOf, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("object", (Object)node.getValue());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.addConst("allowsNull", (Object)node.allowsNull());
            args.add("start", (Object)hub.getTypeCheckStart());
            args.add("range", (Object)hub.getTypeCheckRange());
            args.add("slot", (Object)hub.getTypeCheckSlot());
            args.addConst("typeIDSlotOffset", (Object)TypeSnippets.this.runtimeConfig.getTypeIDSlotsOffset());
            return args;
        }
    }
}

