/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.allocationprofile.AllocationCounter;
import com.oracle.svm.core.allocationprofile.AllocationSite;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.NewStoredContinuationNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewHybridInstanceNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.PiArrayNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.ForeignCallWithExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.ValidateNewInstanceClassNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.AllocationSnippets;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class SubstrateAllocationSnippets
extends AllocationSnippets {
    public static final LocationIdentity TLAB_TOP_IDENTITY = NamedLocationIdentity.mutable((String)"TLAB.top");
    public static final LocationIdentity TLAB_END_IDENTITY = NamedLocationIdentity.mutable((String)"TLAB.end");
    public static final Object[] ALLOCATION_LOCATIONS = new Object[]{TLAB_TOP_IDENTITY, TLAB_END_IDENTITY, AllocationCounter.COUNT_FIELD, AllocationCounter.SIZE_FIELD};
    public static final LocationIdentity[] TLAB_LOCATIONS = new LocationIdentity[]{TLAB_TOP_IDENTITY, TLAB_END_IDENTITY};
    private static final SnippetRuntime.SubstrateForeignCallDescriptor NEW_MULTI_ARRAY = SnippetRuntime.findForeignCall(SubstrateAllocationSnippets.class, "newMultiArrayStub", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor HUB_ERROR = SnippetRuntime.findForeignCall(SubstrateAllocationSnippets.class, "hubErrorStub", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAY_HUB_ERROR = SnippetRuntime.findForeignCall(SubstrateAllocationSnippets.class, "arrayHubErrorStub", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{NEW_MULTI_ARRAY, HUB_ERROR, ARRAY_HUB_ERROR};
    private static final String RUNTIME_REFLECTION_TYPE_NAME = RuntimeReflection.class.getTypeName();

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    @Snippet
    protected Object allocateInstance(@Snippet.NonNullParameter DynamicHub hub, @Snippet.ConstantParameter long size, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        Object result = this.allocateInstanceImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), (Word)WordFactory.nullPointer(), WordFactory.unsigned((long)size), fillContents, emitMemoryBarrier, true, profilingData);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    @Snippet
    protected Object allocateStoredContinuationInstance(@Snippet.NonNullParameter DynamicHub hub, long size, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        Object result = this.allocateInstanceImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), (Word)WordFactory.nullPointer(), WordFactory.unsigned((long)size), AllocationSnippets.FillContent.WITH_GARBAGE_IF_ASSERTIONS_ENABLED, true, false, profilingData);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    @Snippet
    public Object allocateArray(@Snippet.NonNullParameter DynamicHub hub, int length, @Snippet.ConstantParameter int arrayBaseOffset, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter int fillStartOffset, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        Object result = this.allocateArrayImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), (Word)WordFactory.nullPointer(), length, arrayBaseOffset, log2ElementSize, fillContents, fillStartOffset, emitMemoryBarrier, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, profilingData);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)length);
    }

    @Snippet
    public Object allocateInstanceDynamic(@Snippet.NonNullParameter DynamicHub hub, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        UnsignedWord size = LayoutEncoding.getInstanceSize(hub.getLayoutEncoding());
        Object result = this.allocateInstanceImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), (Word)WordFactory.nullPointer(), size, fillContents, emitMemoryBarrier, false, profilingData);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    @Snippet
    public Object allocateArrayDynamic(DynamicHub elementType, int length, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        DynamicHub checkedArrayHub = SubstrateAllocationSnippets.getCheckedArrayHub(elementType);
        int layoutEncoding = checkedArrayHub.getLayoutEncoding();
        int arrayBaseOffset = SubstrateAllocationSnippets.getArrayBaseOffset(layoutEncoding);
        int log2ElementSize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
        Object result = this.allocateArrayImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(checkedArrayHub), (Word)WordFactory.nullPointer(), length, arrayBaseOffset, log2ElementSize, fillContents, arrayBaseOffset, emitMemoryBarrier, false, supportsBulkZeroing, supportsOptimizedFilling, profilingData);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)length);
    }

    @Snippet
    protected Object newmultiarray(DynamicHub hub, @Snippet.ConstantParameter int rank, @Snippet.VarargsParameter int[] dimensions) {
        return this.newMultiArrayImpl(Word.objectToUntrackedPointer((Object)hub), rank, dimensions);
    }

    @Snippet
    private static DynamicHub validateNewInstanceClass(DynamicHub hub) {
        DynamicHub nonNullHub;
        if (BranchProbabilityNode.probability((double)0.999999, (hub != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (boolean)LayoutEncoding.isInstance((nonNullHub = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor())).getLayoutEncoding())) && BranchProbabilityNode.probability((double)0.999999, (boolean)nonNullHub.isInstantiated())) {
            return nonNullHub;
        }
        SubstrateAllocationSnippets.callHubErrorWithExceptionStub(HUB_ERROR, DynamicHub.toClass(hub));
        throw UnreachableNode.unreachable();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object newMultiArrayStub(Word dynamicHub, int rank, Word dimensionsStackValue) {
        DynamicHub hub = (DynamicHub)dynamicHub.toObject();
        return SubstrateAllocationSnippets.newMultiArrayRecursion(hub, rank, dimensionsStackValue);
    }

    private static Object newMultiArrayRecursion(DynamicHub hub, int rank, Word dimensionsStackValue) {
        int length = dimensionsStackValue.readInt(0);
        Object result = Array.newInstance(DynamicHub.toClass(hub.getComponentHub()), length);
        if (rank > 1) {
            UnsignedWord offset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
            UnsignedWord endOffset = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), length);
            while (offset.belowThan(endOffset)) {
                BarrieredAccess.writeObject((Object)result, (WordBase)offset, (Object)SubstrateAllocationSnippets.newMultiArrayRecursion(hub.getComponentHub(), rank - 1, dimensionsStackValue.add(4)));
                offset = offset.add(ConfigurationValues.getObjectLayout().getReferenceSize());
            }
        }
        return result;
    }

    @Node.NodeIntrinsic(value=ForeignCallWithExceptionNode.class)
    private static native void callHubErrorWithExceptionStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void hubErrorStub(DynamicHub hub) throws InstantiationException {
        if (hub == null) {
            throw new NullPointerException("Allocation type is null.");
        }
        if (!LayoutEncoding.isInstance(hub.getLayoutEncoding())) {
            throw new InstantiationException("Cannot allocate instance.");
        }
        if (!hub.isInstantiated()) {
            throw new IllegalArgumentException("Class " + DynamicHub.toClass(hub).getTypeName() + " is instantiated reflectively but was never registered. Register the class by using " + RUNTIME_REFLECTION_TYPE_NAME);
        }
        throw VMError.shouldNotReachHere();
    }

    private static DynamicHub getCheckedArrayHub(DynamicHub elementType) {
        DynamicHub nonNullArrayHub;
        DynamicHub nonNullElementType;
        DynamicHub arrayHub;
        if (BranchProbabilityNode.probability((double)0.999999, (elementType != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (elementType != DynamicHub.fromClass(Void.TYPE) ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, ((arrayHub = (nonNullElementType = (DynamicHub)PiNode.piCastNonNull((Object)elementType, (GuardingNode)SnippetAnchorNode.anchor())).getArrayHub()) != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (boolean)(nonNullArrayHub = (DynamicHub)PiNode.piCastNonNull((Object)arrayHub, (GuardingNode)SnippetAnchorNode.anchor())).isInstantiated())) {
            return nonNullArrayHub;
        }
        SubstrateAllocationSnippets.callArrayHubErrorStub(ARRAY_HUB_ERROR, DynamicHub.toClass(elementType));
        throw UnreachableNode.unreachable();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callArrayHubErrorStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void arrayHubErrorStub(DynamicHub elementType) {
        if (elementType == null) {
            throw new NullPointerException("Allocation type is null.");
        }
        if (elementType == DynamicHub.fromClass(Void.TYPE)) {
            throw new IllegalArgumentException("Cannot allocate void array.");
        }
        if (elementType.getArrayHub() == null || !elementType.getArrayHub().isInstantiated()) {
            throw new IllegalArgumentException("Class " + DynamicHub.toClass(elementType).getTypeName() + "[] is instantiated reflectively but was never registered. Register the class by using " + RUNTIME_REFLECTION_TYPE_NAME);
        }
        VMError.shouldNotReachHere();
    }

    protected final int getPrefetchStyle() {
        return SubstrateOptions.AllocatePrefetchStyle.getValue();
    }

    protected int getPrefetchLines(boolean isArray) {
        if (isArray) {
            return SubstrateOptions.AllocatePrefetchLines.getValue();
        }
        return SubstrateOptions.AllocateInstancePrefetchLines.getValue();
    }

    protected final int getPrefetchStepSize() {
        return SubstrateOptions.AllocatePrefetchStepSize.getValue();
    }

    protected final int getPrefetchDistance() {
        return SubstrateOptions.AllocatePrefetchDistance.getValue();
    }

    protected final int instanceHeaderSize() {
        return ConfigurationValues.getObjectLayout().getFirstFieldOffset();
    }

    protected static int afterArrayLengthOffset() {
        return ConfigurationValues.getObjectLayout().getArrayLengthOffset() + ConfigurationValues.getObjectLayout().sizeInBytes(JavaKind.Int);
    }

    protected final void profileAllocation(AllocationSnippets.AllocationProfilingData profilingData, UnsignedWord size) {
        if (AllocationSite.Options.AllocationProfiling.getValue().booleanValue()) {
            SubstrateAllocationProfilingData svmProfilingData = (SubstrateAllocationProfilingData)profilingData;
            AllocationCounter allocationSiteCounter = svmProfilingData.allocationSiteCounter;
            allocationSiteCounter.incrementCount();
            allocationSiteCounter.incrementSize(size.rawValue());
        }
    }

    @Fold
    protected int getMinimalBulkZeroingSize() {
        return (Integer)GraalOptions.MinimalBulkZeroingSize.getValue(HostedOptionValues.singleton());
    }

    protected final Object verifyOop(Object obj) {
        return obj;
    }

    public final int arrayLengthOffset() {
        return ConfigurationValues.getObjectLayout().getArrayLengthOffset();
    }

    protected final int objectAlignment() {
        return ConfigurationValues.getObjectLayout().getAlignment();
    }

    protected static int getArrayBaseOffset(int layoutEncoding) {
        return (int)LayoutEncoding.getArrayBaseOffset(layoutEncoding).rawValue();
    }

    public static Word encodeAsTLABObjectHeader(DynamicHub hub) {
        return Heap.getHeap().getObjectHeader().encodeAsTLABObjectHeader(hub);
    }

    protected final Object callNewInstanceStub(Word objectHeader, UnsignedWord size) {
        return SubstrateAllocationSnippets.callSlowNewInstance(this.getSlowNewInstanceStub(), objectHeader, size);
    }

    protected final Object callNewInstanceStub(Word objectHeader) {
        throw VMError.shouldNotReachHere("callNewInstanceStub with size should be used to support dynamic allocation");
    }

    protected final Object callNewArrayStub(Word objectHeader, int length, int fillStartOffset) {
        return SubstrateAllocationSnippets.callSlowNewArray(this.getSlowNewArrayStub(), objectHeader, length, fillStartOffset);
    }

    protected final Object callNewMultiArrayStub(Word objectHeader, int rank, Word dims) {
        return SubstrateAllocationSnippets.callNewMultiArray(NEW_MULTI_ARRAY, objectHeader, rank, dims);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, UnsignedWord var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, int var3);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callNewMultiArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, Word var3);

    protected abstract SnippetRuntime.SubstrateForeignCallDescriptor getSlowNewInstanceStub();

    protected abstract SnippetRuntime.SubstrateForeignCallDescriptor getSlowNewArrayStub();

    public static DynamicHub ensureMarkedAsInstantiated(DynamicHub hub) {
        if (!hub.isInstantiated()) {
            throw VMError.shouldNotReachHere("Cannot allocate type that is not marked as instantiated: " + hub.getName());
        }
        return hub;
    }

    public static abstract class Templates
    extends SubstrateTemplates {
        protected final AllocationSnippets.AllocationSnippetCounters snippetCounters;
        private final AllocationSnippets.AllocationProfilingData profilingData;
        private final SnippetTemplate.SnippetInfo allocateInstance;
        private final SnippetTemplate.SnippetInfo allocateArray;
        private final SnippetTemplate.SnippetInfo newmultiarray;
        private final SnippetTemplate.SnippetInfo allocateArrayDynamic;
        private final SnippetTemplate.SnippetInfo allocateInstanceDynamic;
        private final SnippetTemplate.SnippetInfo allocateStoredContinuationInstance;
        private final SnippetTemplate.SnippetInfo validateNewInstanceClass;

        public Templates(SubstrateAllocationSnippets receiver, OptionValues options, SnippetCounter.Group.Factory groupFactory, Providers providers) {
            super(options, providers);
            this.snippetCounters = new AllocationSnippets.AllocationSnippetCounters(groupFactory);
            this.profilingData = new SubstrateAllocationProfilingData(this.snippetCounters, null);
            this.allocateInstance = this.snippet(SubstrateAllocationSnippets.class, "allocateInstance", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateArray = this.snippet(SubstrateAllocationSnippets.class, "allocateArray", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateInstanceDynamic = this.snippet(SubstrateAllocationSnippets.class, "allocateInstanceDynamic", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateStoredContinuationInstance = this.snippet(SubstrateAllocationSnippets.class, "allocateStoredContinuationInstance", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateArrayDynamic = this.snippet(SubstrateAllocationSnippets.class, "allocateArrayDynamic", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.newmultiarray = this.snippet(SubstrateAllocationSnippets.class, "newmultiarray", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.validateNewInstanceClass = this.snippet(SubstrateAllocationSnippets.class, "validateNewInstanceClass", ALLOCATION_LOCATIONS);
        }

        public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
            lowerings.put(NewInstanceNode.class, new NewInstanceLowering());
            lowerings.put(SubstrateNewHybridInstanceNode.class, new NewHybridInstanceLowering());
            lowerings.put(NewArrayNode.class, new NewArrayLowering());
            lowerings.put(DynamicNewInstanceNode.class, new DynamicNewInstanceLowering());
            lowerings.put(DynamicNewArrayNode.class, new DynamicNewArrayLowering());
            lowerings.put(NewMultiArrayNode.class, new NewMultiArrayLowering());
            lowerings.put(NewStoredContinuationNode.class, new NewStoredContinuationLowering());
            lowerings.put(ValidateNewInstanceClassNode.class, new ValidateNewInstanceClassLowering());
        }

        private AllocationSnippets.AllocationProfilingData getProfilingData(ValueNode node, ResolvedJavaType type) {
            if (AllocationSite.Options.AllocationProfiling.getValue().booleanValue()) {
                return new SubstrateAllocationProfilingData(this.snippetCounters, Templates.createAllocationSiteCounter(node, type));
            }
            return this.profilingData;
        }

        private static AllocationCounter createAllocationSiteCounter(ValueNode node, ResolvedJavaType type) {
            String siteName = "[others]";
            if (node.getNodeSourcePosition() != null) {
                siteName = node.getNodeSourcePosition().getMethod().asStackTraceElement(node.getNodeSourcePosition().getBCI()).toString();
            }
            String className = "[dynamic]";
            if (type != null) {
                className = type.toJavaName(true);
            }
            AllocationSite allocationSite = AllocationSite.lookup(siteName, className);
            String counterName = node.graph().name;
            if (counterName == null) {
                counterName = node.graph().method().format("%H.%n(%p)");
            }
            return allocationSite.createCounter(counterName);
        }

        private class ValidateNewInstanceClassLowering
        implements NodeLoweringProvider<ValidateNewInstanceClassNode> {
            private ValidateNewInstanceClassLowering() {
            }

            @Override
            public void lower(ValidateNewInstanceClassNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.validateNewInstanceClass, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)node.getInstanceType());
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class DynamicNewArrayLowering
        implements NodeLoweringProvider<DynamicNewArrayNode> {
            private DynamicNewArrayLowering() {
            }

            @Override
            public void lower(DynamicNewArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateArrayDynamic, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("elementType", (Object)node.getElementType());
                args.add("length", (Object)node.length());
                args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)node.fillContents()));
                args.addConst("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.addConst("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroing());
                args.addConst("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.addConst("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class DynamicNewInstanceLowering
        implements NodeLoweringProvider<DynamicNewInstanceNode> {
            private DynamicNewInstanceLowering() {
            }

            @Override
            public void lower(DynamicNewInstanceNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateInstanceDynamic, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)node.getInstanceType());
                args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)node.fillContents()));
                args.addConst("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.addConst("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class NewMultiArrayLowering
        implements NodeLoweringProvider<NewMultiArrayNode> {
            private NewMultiArrayLowering() {
            }

            @Override
            public void lower(NewMultiArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                int rank = node.dimensionCount();
                ValueNode[] dims = new ValueNode[rank];
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    dims[i] = node.dimension(i);
                }
                SharedType type = (SharedType)node.type();
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(type.getHub()), (MetaAccessProvider)Templates.this.providers.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.newmultiarray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.addConst("rank", (Object)rank);
                args.addVarargs("dimensions", Integer.TYPE, StampFactory.forKind((JavaKind)JavaKind.Int), (Object)dims);
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class NewArrayLowering
        implements NodeLoweringProvider<NewArrayNode> {
            private NewArrayLowering() {
            }

            @Override
            public void lower(NewArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                ValueNode length = node.length();
                SharedType type = (SharedType)node.elementType().getArrayClass();
                DynamicHub hub = SubstrateAllocationSnippets.ensureMarkedAsInstantiated(type.getHub());
                int layoutEncoding = hub.getLayoutEncoding();
                int arrayBaseOffset = SubstrateAllocationSnippets.getArrayBaseOffset(layoutEncoding);
                int log2ElementSize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(hub), (MetaAccessProvider)Templates.this.providers.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateArray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs((Node)length));
                args.addConst("arrayBaseOffset", (Object)arrayBaseOffset);
                args.addConst("log2ElementSize", (Object)log2ElementSize);
                args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)node.fillContents()));
                args.addConst("fillStartOffset", (Object)SubstrateAllocationSnippets.afterArrayLengthOffset());
                args.addConst("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.addConst("maybeUnroll", (Object)length.isConstant());
                args.addConst("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroing());
                args.addConst("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.addConst("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, type));
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class NewHybridInstanceLowering
        implements NodeLoweringProvider<SubstrateNewHybridInstanceNode> {
            private NewHybridInstanceLowering() {
            }

            @Override
            public void lower(SubstrateNewHybridInstanceNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SharedType instanceClass = (SharedType)node.instanceClass();
                ValueNode length = node.length();
                DynamicHub hub = instanceClass.getHub();
                int layoutEncoding = hub.getLayoutEncoding();
                int arrayBaseOffset = (int)LayoutEncoding.getArrayBaseOffset(layoutEncoding).rawValue();
                int log2ElementSize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
                boolean fillContents = node.fillContents();
                assert (fillContents) : "fillContents must be true for hybrid allocations";
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(hub), (MetaAccessProvider)Templates.this.providers.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateArray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs((Node)length));
                args.addConst("arrayBaseOffset", (Object)arrayBaseOffset);
                args.addConst("log2ElementSize", (Object)log2ElementSize);
                args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)fillContents));
                args.addConst("fillStartOffset", (Object)SubstrateAllocationSnippets.afterArrayLengthOffset());
                args.addConst("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.addConst("maybeUnroll", (Object)length.isConstant());
                args.addConst("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroing());
                args.addConst("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.addConst("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, instanceClass));
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class NewInstanceLowering
        implements NodeLoweringProvider<NewInstanceNode> {
            private NewInstanceLowering() {
            }

            @Override
            public void lower(NewInstanceNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SharedType type = (SharedType)node.instanceClass();
                DynamicHub hub = SubstrateAllocationSnippets.ensureMarkedAsInstantiated(type.getHub());
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(hub), (MetaAccessProvider)Templates.this.providers.getMetaAccess(), (StructuredGraph)graph);
                long size = LayoutEncoding.getInstanceSize(hub.getLayoutEncoding()).rawValue();
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateInstance, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.addConst("size", (Object)size);
                args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)node.fillContents()));
                args.addConst("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.addConst("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, type));
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class NewStoredContinuationLowering
        implements NodeLoweringProvider<NewStoredContinuationNode> {
            private NewStoredContinuationLowering() {
            }

            @Override
            public void lower(NewStoredContinuationNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                DynamicHub hub = ((SharedType)tool.getMetaAccess().lookupJavaType(StoredContinuation.class)).getHub();
                assert (hub.isStoredContinuationClass());
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(hub), (MetaAccessProvider)Templates.this.providers.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateStoredContinuationInstance, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.add("size", (Object)node.getSize());
                args.addConst("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }

    public static class SubstrateAllocationProfilingData
    extends AllocationSnippets.AllocationProfilingData {
        final AllocationCounter allocationSiteCounter;

        public SubstrateAllocationProfilingData(AllocationSnippets.AllocationSnippetCounters snippetCounters, AllocationCounter allocationSiteCounter) {
            super(snippetCounters);
            this.allocationSiteCounter = allocationSiteCounter;
        }
    }
}

