/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadExceptionObjectNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

public final class ExceptionSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    @NeverInline(value="All methods accessing caller frame must have this annotation. The requirement would not be necessary for a snippet, but the annotation does not matter on the snippet root method, so having the annotation is easier than coding an exception to the annotation checker.")
    protected static void unwindSnippet(Throwable exception, @Snippet.ConstantParameter boolean fromMethodWithCalleeSavedRegisters) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        if (fromMethodWithCalleeSavedRegisters) {
            SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)ExceptionUnwind.UNWIND_EXCEPTION_WITH_CALLEE_SAVED_REGISTERS, exception, callerSP);
        } else {
            SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)ExceptionUnwind.UNWIND_EXCEPTION_WITHOUT_CALLEE_SAVED_REGISTERS, exception, callerSP);
        }
        throw UnreachableNode.unreachable();
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new ExceptionSnippets(options, providers, lowerings);
    }

    private ExceptionSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        lowerings.put(UnwindNode.class, new UnwindLowering());
    }

    public static class LoadExceptionObjectLowering
    implements NodeLoweringProvider<LoadExceptionObjectNode> {
        @Override
        public void lower(LoadExceptionObjectNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            FixedWithNextNode readRegNode = (FixedWithNextNode)graph.add((Node)new ReadExceptionObjectNode(StampFactory.objectNonNull()));
            graph.replaceFixedWithFixed((FixedWithNextNode)node, readRegNode);
        }
    }

    protected class UnwindLowering
    implements NodeLoweringProvider<UnwindNode> {
        private final SnippetTemplate.SnippetInfo unwind;

        protected UnwindLowering() {
            this.unwind = ExceptionSnippets.this.snippet(ExceptionSnippets.class, "unwindSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(UnwindNode node, LoweringTool tool) {
            if (node.graph().isSubstitution()) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.unwind, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("exception", (Object)node.exception());
            args.addConst("fromMethodWithCalleeSavedRegisters", (Object)((SharedMethod)node.graph().method()).hasCalleeSavedRegisters());
            ExceptionSnippets.this.template((ValueNode)node, args).instantiate(ExceptionSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

