/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.StaticFieldBaseNode;
import com.oracle.svm.core.util.VMError;
import java.util.Objects;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class StaticFieldsSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Object[] staticObjectFields;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private byte[] staticPrimitiveFields;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected StaticFieldsSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setData(Object[] staticObjectFields, byte[] staticPrimitiveFields) {
        StaticFieldsSupport support = (StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class);
        support.staticObjectFields = Objects.requireNonNull(staticObjectFields);
        support.staticPrimitiveFields = Objects.requireNonNull(staticPrimitiveFields);
    }

    public static Object getStaticObjectFields() {
        Object[] result = ((StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class)).staticObjectFields;
        VMError.guarantee(result != null, "arrays that hold static fields are only available after static analysis");
        return result;
    }

    public static Object getStaticPrimitiveFields() {
        byte[] result = ((StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class)).staticPrimitiveFields;
        VMError.guarantee(result != null, "arrays that hold static fields are only available after static analysis");
        return result;
    }

    public static FloatingNode createStaticFieldBaseNode(boolean primitive) {
        return new StaticFieldBaseNode(primitive);
    }
}

