
package org.glassfish.jersey.simple.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.simple.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableWRONG_SCHEME_WHEN_USING_HTTP() {
        return messageFactory.getMessage("wrong.scheme.when.using.http");
    }

    /**
     * The URI scheme should be 'http' when not using SSL.
     * 
     */
    public static String WRONG_SCHEME_WHEN_USING_HTTP() {
        return localizer.localize(localizableWRONG_SCHEME_WHEN_USING_HTTP());
    }

    public static Localizable localizableERROR_WHEN_CREATING_SERVER() {
        return messageFactory.getMessage("error.when.creating.server");
    }

    /**
     * IOException thrown when trying to create simple server.
     * 
     */
    public static String ERROR_WHEN_CREATING_SERVER() {
        return localizer.localize(localizableERROR_WHEN_CREATING_SERVER());
    }

    public static Localizable localizableWRONG_SCHEME_WHEN_USING_HTTPS() {
        return messageFactory.getMessage("wrong.scheme.when.using.https");
    }

    /**
     * The URI scheme should be 'https' when using SSL.
     * 
     */
    public static String WRONG_SCHEME_WHEN_USING_HTTPS() {
        return localizer.localize(localizableWRONG_SCHEME_WHEN_USING_HTTPS());
    }

    public static Localizable localizableURI_CANNOT_BE_NULL() {
        return messageFactory.getMessage("uri.cannot.be.null");
    }

    /**
     * The URI must not be null.
     * 
     */
    public static String URI_CANNOT_BE_NULL() {
        return localizer.localize(localizableURI_CANNOT_BE_NULL());
    }

}
