/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.tycho.p2.remote.RemoteRepositoryLoadingHelper;

class RemoteArtifactRepositoryManager
implements IArtifactRepositoryManager {
    private IArtifactRepositoryManager delegate;
    private final RemoteRepositoryLoadingHelper loadingHelper;

    RemoteArtifactRepositoryManager(IArtifactRepositoryManager delegate, RemoteRepositoryLoadingHelper loadingHelper) {
        this.delegate = delegate;
        this.loadingHelper = loadingHelper;
    }

    private URI translate(URI location) {
        return this.loadingHelper.getEffectiveLocation(location);
    }

    private URI translateAndPrepareLoad(URI location) throws ProvisionException {
        return this.loadingHelper.getEffectiveLocationAndPrepareLoad(location);
    }

    public void addRepository(URI location) {
        this.delegate.addRepository(this.translate(location));
    }

    public boolean contains(URI location) {
        return this.delegate.contains(this.translate(location));
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Map<String, String> destinationDescriptorProperties, Map<String, String> destinationRepositoryProperties) {
        return this.delegate.createMirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties);
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Map<String, String> destinationDescriptorProperties, Map<String, String> destinationRepositoryProperties, String downloadStatsParameters) {
        return this.delegate.createMirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties, downloadStatsParameters);
    }

    public IArtifactRepository createRepository(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
        return this.delegate.createRepository(this.translate(location), name, type, properties);
    }

    public IProvisioningAgent getAgent() {
        return this.delegate.getAgent();
    }

    public URI[] getKnownRepositories(int flags) {
        return this.delegate.getKnownRepositories(flags);
    }

    public String getRepositoryProperty(URI location, String key) {
        return this.delegate.getRepositoryProperty(this.translate(location), key);
    }

    public boolean isEnabled(URI location) {
        return this.delegate.isEnabled(this.translate(location));
    }

    public IArtifactRepository loadRepository(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        return this.delegate.loadRepository(this.translateAndPrepareLoad(location), flags, monitor);
    }

    public IArtifactRepository loadRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        return this.delegate.loadRepository(this.translateAndPrepareLoad(location), monitor);
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return this.delegate.query(query, monitor);
    }

    public IArtifactRepository refreshRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        return this.delegate.refreshRepository(this.translateAndPrepareLoad(location), monitor);
    }

    public boolean removeRepository(URI location) {
        return this.delegate.removeRepository(this.translate(location));
    }

    public void setEnabled(URI location, boolean enablement) {
        this.delegate.setEnabled(this.translate(location), enablement);
    }

    public void setRepositoryProperty(URI location, String key, String value) {
        this.delegate.setRepositoryProperty(this.translate(location), key, value);
    }
}

