/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.server.internal;

import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.eclipse.jetty.websocket.jakarta.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketExtension;
import org.eclipse.jetty.websocket.jakarta.common.ServerEndpointConfigWrapper;
import org.eclipse.jetty.websocket.jakarta.server.internal.AnnotatedServerEndpointConfig;
import org.eclipse.jetty.websocket.jakarta.server.internal.JsrHandshakeRequest;
import org.eclipse.jetty.websocket.jakarta.server.internal.JsrHandshakeResponse;
import org.eclipse.jetty.websocket.jakarta.server.internal.PathParamServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaWebSocketCreator
implements WebSocketCreator {
    public static final String PROP_REMOTE_ADDRESS = "jakarta.websocket.endpoint.remoteAddress";
    public static final String PROP_LOCAL_ADDRESS = "jakarta.websocket.endpoint.localAddress";
    public static final String PROP_LOCALES = "jakarta.websocket.upgrade.locales";
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketCreator.class);
    private final JakartaWebSocketContainer containerScope;
    private final ServerEndpointConfig baseConfig;
    private final WebSocketExtensionRegistry extensionRegistry;

    public JakartaWebSocketCreator(JakartaWebSocketContainer containerScope, ServerEndpointConfig config, WebSocketExtensionRegistry extensionRegistry) {
        this.containerScope = containerScope;
        this.baseConfig = config;
        this.extensionRegistry = extensionRegistry;
    }

    public Object createWebSocket(ServerUpgradeRequest req, ServerUpgradeResponse resp) {
        List requested;
        JsrHandshakeRequest jsrHandshakeRequest = new JsrHandshakeRequest(req);
        JsrHandshakeResponse jsrHandshakeResponse = new JsrHandshakeResponse(resp);
        ServerEndpointConfigWrapper config = new ServerEndpointConfigWrapper(this.baseConfig){
            final Map<String, Object> userProperties;
            {
                this.userProperties = new HashMap<String, Object>(JakartaWebSocketCreator.this.baseConfig.getUserProperties());
            }

            public Map<String, Object> getUserProperties() {
                return this.userProperties;
            }
        };
        Map userProperties = config.getUserProperties();
        userProperties.put(PROP_LOCAL_ADDRESS, req.getLocalSocketAddress());
        userProperties.put(PROP_REMOTE_ADDRESS, req.getRemoteSocketAddress());
        userProperties.put(PROP_LOCALES, Collections.list(req.getLocales()));
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (!configurator.checkOrigin(req.getOrigin())) {
            block14: {
                try {
                    resp.sendForbidden("Origin mismatch");
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block14;
                    LOG.debug("Unable to send error response", (Throwable)e);
                }
            }
            return null;
        }
        List supported = config.getSubprotocols();
        String subprotocol = configurator.getNegotiatedSubprotocol(supported, requested = req.getSubProtocols());
        if (StringUtil.isNotBlank((String)subprotocol)) {
            resp.setAcceptedSubProtocol(subprotocol);
        }
        ArrayList<JakartaWebSocketExtension> installedExtensions = new ArrayList<JakartaWebSocketExtension>();
        for (Object extName : this.extensionRegistry.getAvailableExtensions().keySet()) {
            installedExtensions.add(new JakartaWebSocketExtension((String)extName));
        }
        ArrayList<JakartaWebSocketExtension> requestedExts = new ArrayList<JakartaWebSocketExtension>();
        for (ExtensionConfig reqCfg : req.getExtensions()) {
            requestedExts.add(new JakartaWebSocketExtension(reqCfg));
        }
        List usedExtensions = configurator.getNegotiatedExtensions(installedExtensions, requestedExts);
        ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
        if (usedExtensions != null) {
            for (Extension used : usedExtensions) {
                ExtensionConfig ecfg = new ExtensionConfig(used.getName());
                for (Extension.Parameter param : used.getParameters()) {
                    ecfg.setParameter(param.getName(), param.getValue());
                }
                configs.add(ecfg);
            }
        }
        resp.setExtensions(configs);
        PathSpec pathSpecObject = jsrHandshakeRequest.getRequestPathSpec();
        if (pathSpecObject instanceof UriTemplatePathSpec) {
            UriTemplatePathSpec pathSpec = (UriTemplatePathSpec)pathSpecObject;
            Map pathParams = pathSpec.getPathParams(req.getRequestPath());
            config = new PathParamServerEndpointConfig((ServerEndpointConfig)config, pathParams);
        } else {
            Map<String, String> pathParams = jsrHandshakeRequest.getPathParams();
            if (pathParams != null) {
                config = new PathParamServerEndpointConfig((ServerEndpointConfig)config, pathParams);
            }
        }
        configurator.modifyHandshake((ServerEndpointConfig)config, (HandshakeRequest)jsrHandshakeRequest, (HandshakeResponse)jsrHandshakeResponse);
        jsrHandshakeResponse.setHeaders(jsrHandshakeResponse.getHeaders());
        try {
            Class endpointClass = config.getEndpointClass();
            Object endpoint = config.getConfigurator().getEndpointInstance(endpointClass);
            return new ConfiguredEndpoint(endpoint, (EndpointConfig)config);
        }
        catch (InstantiationException e) {
            LOG.warn("Unable to create websocket: {}", (Object)config.getEndpointClass().getName(), (Object)e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JakartaWebSocketCreator that = (JakartaWebSocketCreator)o;
        return Objects.equals(this.baseConfig, that.baseConfig);
    }

    public int hashCode() {
        return this.baseConfig != null ? this.baseConfig.hashCode() : 0;
    }

    public String toString() {
        return String.format("JsrCreator[%s%s]", this.baseConfig instanceof AnnotatedServerEndpointConfig ? "@" : "", this.baseConfig.getEndpointClass().getName());
    }
}

