/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.frames;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.WebSocketFrame;

public class DataFrame
extends WebSocketFrame {
    private ByteBufferPool pool;

    protected DataFrame(byte opcode) {
        super(opcode);
    }

    public DataFrame(Frame basedOn) {
        this(basedOn, false);
    }

    public DataFrame(Frame basedOn, boolean continuation) {
        super(basedOn.getOpCode());
        this.copyHeaders(basedOn);
        if (continuation) {
            this.setOpCode((byte)0);
        }
    }

    @Override
    public void assertValid() {
    }

    @Override
    public boolean isControlFrame() {
        return false;
    }

    @Override
    public boolean isDataFrame() {
        return true;
    }

    @Override
    public void reset() {
        if (this.pool != null) {
            this.pool.release(this.data);
        }
        super.reset();
    }

    public void setIsContinuation() {
        this.setOpCode((byte)0);
    }

    public void setBufferPool(ByteBufferPool pool) {
        this.pool = pool;
    }
}

