/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.fragment;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class FragmentExtension
extends AbstractExtension {
    private int maxLength = -1;

    @Override
    public String getName() {
        return "fragment";
    }

    @Override
    public void incomingError(Throwable e) {
        this.nextIncomingError(e);
    }

    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    public void outgoingFrame(Frame frame, WriteCallback callback) {
        DataFrame frag;
        if (OpCode.isControlFrame(frame.getOpCode())) {
            this.nextOutgoingFrame(frame, callback);
            return;
        }
        ByteBuffer payload = frame.getPayload().slice();
        int originalLimit = payload.limit();
        int currentPosition = payload.position();
        if (this.maxLength <= 0) {
            this.nextOutgoingFrame(frame, callback);
            return;
        }
        boolean continuation = false;
        for (int length = frame.getPayloadLength(); length > this.maxLength; length -= this.maxLength) {
            frag = new DataFrame(frame, continuation);
            frag.setFin(false);
            payload.position(currentPosition);
            payload.limit(Math.min(payload.position() + this.maxLength, originalLimit));
            frag.setPayload(payload);
            this.nextOutgoingFrame(frag, null);
            continuation = true;
            currentPosition = payload.limit();
        }
        frag = new DataFrame(frame, continuation);
        frag.setFin(frame.isFin());
        payload.position(currentPosition);
        payload.limit(originalLimit);
        frag.setPayload(payload);
        this.nextOutgoingFrame(frag, callback);
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        this.maxLength = config.getParameter("maxLength", this.maxLength);
    }
}

