/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebXmlProcessor;
import org.eclipse.jetty.xml.XmlParser;

public class Descriptor {
    protected Resource _xml;
    protected XmlParser.Node _root;
    protected MetaDataComplete _metaDataComplete;
    protected int _majorVersion = 3;
    protected int _minorVersion = 0;
    protected ArrayList<String> _classNames;
    protected boolean _distributable;
    protected boolean _validating;
    protected WebXmlProcessor _processor;
    protected boolean _isOrdered = false;
    protected List<String> _ordering = new ArrayList<String>();

    public Descriptor(Resource xml, WebXmlProcessor processor) {
        this._xml = xml;
        this._processor = processor;
    }

    public void parse() throws Exception {
        if (this._root == null) {
            this._root = this._processor.getParser().parse(this._xml.getURL().toString());
            this.processVersion();
            this.processOrdering();
        }
    }

    public MetaDataComplete getMetaDataComplete() {
        return this._metaDataComplete;
    }

    public XmlParser.Node getRoot() {
        return this._root;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public Resource getResource() {
        return this._xml;
    }

    public void processVersion() {
        String s;
        String version = this._root.getAttribute("version", "DTD");
        if ("DTD".equals(version)) {
            this._majorVersion = 2;
            this._minorVersion = 3;
            String dtd = this._processor.getParser().getDTD();
            if (dtd != null && dtd.indexOf("web-app_2_2") >= 0) {
                this._majorVersion = 2;
                this._minorVersion = 2;
            }
        } else {
            int dot = version.indexOf(".");
            if (dot > 0) {
                this._majorVersion = Integer.parseInt(version.substring(0, dot));
                this._minorVersion = Integer.parseInt(version.substring(dot + 1));
            }
        }
        this._metaDataComplete = this._majorVersion < 2 && this._minorVersion < 5 ? MetaDataComplete.True : ((s = this._root.getAttribute("metadata-complete")) == null ? MetaDataComplete.NotSet : (Boolean.valueOf(s) != false ? MetaDataComplete.True : MetaDataComplete.False));
        Log.debug((String)(this._xml.toString() + ": Calculated metadatacomplete = " + (Object)((Object)this._metaDataComplete) + " with version=" + version));
    }

    public void processOrdering() {
        XmlParser.Node ordering = this._root.get("absolute-ordering");
        if (ordering == null) {
            return;
        }
        this._isOrdered = true;
        Iterator iter = ordering.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node = (XmlParser.Node)o;
            if (node.getTag().equalsIgnoreCase("others")) {
                this._ordering.add("others");
                continue;
            }
            if (!node.getTag().equalsIgnoreCase("name")) continue;
            this._ordering.add(node.toString(false, true));
        }
    }

    public void processClassNames() {
        this._classNames = new ArrayList();
        for (Object o : this._root) {
            String className;
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node node = (XmlParser.Node)o;
            String name = node.getTag();
            if ("servlet".equals(name)) {
                className = node.getString("servlet-class", false, true);
                if (className == null) continue;
                this._classNames.add(className);
                continue;
            }
            if ("filter".equals(name)) {
                className = node.getString("filter-class", false, true);
                if (className == null) continue;
                this._classNames.add(className);
                continue;
            }
            if (!"listener".equals(name) || (className = node.getString("listener-class", false, true)) == null) continue;
            this._classNames.add(className);
        }
    }

    public ArrayList<String> getClassNames() {
        return this._classNames;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public boolean isOrdered() {
        return this._isOrdered;
    }

    public List<String> getOrdering() {
        return this._ordering;
    }

    public static enum MetaDataComplete {
        NotSet,
        True,
        False;

    }
}

