/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateLifeCycle
extends AbstractLifeCycle
implements Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(AggregateLifeCycle.class);
    private final List<Object> _dependentBeans = new CopyOnWriteArrayList<Object>();

    @Override
    public void destroy() {
        for (Object o : this._dependentBeans) {
            if (!(o instanceof Destroyable)) continue;
            ((Destroyable)o).destroy();
        }
        this._dependentBeans.clear();
    }

    @Override
    protected void doStart() throws Exception {
        for (Object o : this._dependentBeans) {
            if (!(o instanceof LifeCycle)) continue;
            ((LifeCycle)o).start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ArrayList<Object> reverse = new ArrayList<Object>(this._dependentBeans);
        Collections.reverse(reverse);
        for (Object e : reverse) {
            if (!(e instanceof LifeCycle)) continue;
            ((LifeCycle)e).stop();
        }
    }

    public boolean addBean(Object o) {
        if (o == null) {
            return false;
        }
        boolean added = false;
        if (!this._dependentBeans.contains(o)) {
            this._dependentBeans.add(o);
            added = true;
        }
        try {
            if (this.isStarted() && o instanceof LifeCycle) {
                ((LifeCycle)o).start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return added;
    }

    public Collection<Object> getBeans() {
        return this._dependentBeans;
    }

    public <T> List<T> getBeans(Class<T> clazz) {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Object o : this._dependentBeans) {
            if (!clazz.isInstance(o)) continue;
            beans.add(o);
        }
        return beans;
    }

    public <T> T getBean(Class<T> clazz) {
        Iterator<Object> iter = this._dependentBeans.iterator();
        Object t = null;
        int count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!clazz.isInstance(o)) continue;
            ++count;
            if (t != null) continue;
            t = o;
        }
        if (count > 1 && LOG.isDebugEnabled()) {
            LOG.debug("getBean({}) 1 of {}", clazz.getName(), count);
        }
        return (T)t;
    }

    public void removeBeans() {
        this._dependentBeans.clear();
    }

    public boolean removeBean(Object o) {
        if (o == null) {
            return false;
        }
        return this._dependentBeans.remove(o);
    }

    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    @Override
    public String dump() {
        return AggregateLifeCycle.dump(this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder b = new StringBuilder();
        try {
            dumpable.dump(b, "");
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        return b.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append("\n");
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        AggregateLifeCycle.dump(out, indent, this._dependentBeans);
    }

    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        for (Collection<?> c : collections) {
            size += c.size();
        }
        if (size == 0) {
            return;
        }
        int i = 0;
        for (Collection<?> c : collections) {
            for (Object o : c) {
                ++i;
                out.append(indent).append(" +- ");
                if (o instanceof Dumpable) {
                    ((Dumpable)o).dump(out, indent + (i == size ? "    " : " |  "));
                    continue;
                }
                out.append(String.valueOf(o)).append("\n");
            }
            if (i == size) continue;
            out.append(indent).append(" |\n");
        }
    }
}

