/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class MavenProjectHelper {
    private final Map<String, MavenProject> artifactToLocalProjectMap;

    public MavenProjectHelper(MavenProject project) {
        Set<MavenProject> mavenProjects = MavenProjectHelper.resolveProjectDependencies(project, new HashSet<MavenProject>());
        this.artifactToLocalProjectMap = mavenProjects.stream().collect(Collectors.toMap(MavenProject::getId, Function.identity()));
        this.artifactToLocalProjectMap.put(project.getArtifact().getId(), project);
    }

    public MavenProject getMavenProject(Artifact artifact) {
        return this.artifactToLocalProjectMap.get(artifact.getId());
    }

    public Path getArtifactPath(Artifact artifact) {
        Path path = artifact.getFile().toPath();
        MavenProject mavenProject = this.getMavenProject(artifact);
        if (mavenProject != null) {
            path = "test-jar".equals(artifact.getType()) ? Paths.get(mavenProject.getBuild().getTestOutputDirectory(), new String[0]) : Paths.get(mavenProject.getBuild().getOutputDirectory(), new String[0]);
        }
        return path;
    }

    private static Set<MavenProject> resolveProjectDependencies(MavenProject project, Set<MavenProject> visitedProjects) {
        if (visitedProjects.contains(project)) {
            return Collections.emptySet();
        }
        visitedProjects.add(project);
        HashSet<MavenProject> availableProjects = new HashSet<MavenProject>(project.getProjectReferences().values());
        for (MavenProject ref : project.getProjectReferences().values()) {
            availableProjects.addAll(MavenProjectHelper.resolveProjectDependencies(ref, visitedProjects));
        }
        return availableProjects;
    }
}

