/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableByteList
extends AbstractMutableList<Byte>
implements MutableList<Byte>,
RandomAccess {
    private final MutableByteList delegate;

    public BoxedMutableByteList(MutableByteList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Byte item) {
        return this.delegate.add(item.byteValue());
    }

    public boolean addAll(int index, Collection<? extends Byte> c) {
        byte[] target = new byte[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each;
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Byte get(int index) {
        return this.delegate.get(index);
    }

    public Byte set(int index, Byte element) {
        return this.delegate.set(index, element.byteValue());
    }

    public void add(int index, Byte element) {
        this.delegate.addAtIndex(index, element.byteValue());
    }

    public Byte remove(int index) {
        return this.delegate.removeAtIndex(index);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Byte ? this.delegate.indexOf(((Byte)o).byteValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Byte ? this.delegate.lastIndexOf(((Byte)o).byteValue()) : -1;
    }

    @Override
    public MutableList<Byte> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

