/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.iterator.SingletonCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseCharIterable;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

final class ImmutableCharSingletonList
implements ImmutableCharList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char element1;

    ImmutableCharSingletonList(char element) {
        this.element1 = element;
    }

    public char get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public char getFirst() {
        return this.element1;
    }

    public char getLast() {
        return this.element1;
    }

    public int indexOf(char value) {
        return this.element1 == value ? 0 : -1;
    }

    public int lastIndexOf(char value) {
        return this.element1 == value ? 0 : -1;
    }

    public CharIterator charIterator() {
        return new SingletonCharIterator(this.element1);
    }

    public void each(CharProcedure procedure) {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(CharIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public ImmutableCharList select(CharPredicate predicate) {
        return predicate.accept(this.element1) ? CharArrayList.newListWith(this.element1).toImmutable() : new CharArrayList().toImmutable();
    }

    public ImmutableCharList reject(CharPredicate predicate) {
        return predicate.accept(this.element1) ? new CharArrayList().toImmutable() : CharArrayList.newListWith(this.element1).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function) {
        return Lists.immutable.with(function.valueOf(this.element1));
    }

    public long sum() {
        return this.element1;
    }

    public char max() {
        return this.element1;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.element1;
    }

    public char min() {
        return this.element1;
    }

    public char minIfEmpty(char defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public char[] toSortedArray() {
        return new char[]{this.element1};
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.element1);
    }

    public int binarySearch(char value) {
        if (this.element1 == value) {
            return 0;
        }
        if (this.element1 < value) {
            return -2;
        }
        return -1;
    }

    public long dotProduct(CharList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return (long)this.element1 * (long)list.getFirst();
    }

    public char[] toArray() {
        return new char[]{this.element1};
    }

    public char[] toArray(char[] target) {
        if (target.length < 1) {
            target = new char[]{this.element1};
        } else {
            target[0] = this.element1;
        }
        return target;
    }

    public boolean contains(char value) {
        return this.element1 == value;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public LazyCharIterable asReversed() {
        return ReverseCharIterable.adapt((CharList)this);
    }

    public MutableCharList toList() {
        return CharArrayList.newListWith(this.element1);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.element1);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.element1);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableCharList toImmutable() {
        return this;
    }

    public ImmutableCharSingletonList toReversed() {
        return this;
    }

    public ImmutableCharList newWith(char element) {
        return CharLists.immutable.with(new char[]{this.element1, element});
    }

    public ImmutableCharList newWithout(char element) {
        return this.element1 == element ? CharLists.immutable.with() : this;
    }

    public ImmutableCharList newWithAll(CharIterable elements) {
        CharArrayList arrayList = CharArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableCharList newWithoutAll(CharIterable elements) {
        return elements.contains(this.element1) ? CharLists.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1, 0);
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)this);
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof CharList)) {
            return false;
        }
        CharList list = (CharList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return this.element1 == list.get(0);
    }

    public int hashCode() {
        return 31 + this.element1;
    }

    public String toString() {
        return "[" + this.element1 + "]";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableCharList distinct() {
        return this;
    }

    public ImmutableCharList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    public ImmutableList<CharCharPair> zipChar(CharIterable iterable) {
        if (iterable.isEmpty()) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with((Object)PrimitiveTuples.pair(this.element1, iterable.charIterator().next()));
    }

    public <T> ImmutableList<CharObjectPair<T>> zip(Iterable<T> iterable) {
        if (Iterate.isEmpty(iterable)) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with(PrimitiveTuples.pair(this.element1, Iterate.getFirst(iterable)));
    }
}

