/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.text.style;

import java.awt.Color;
import org.deeplearning4j.ui.api.Style;
import org.deeplearning4j.ui.api.Utils;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StyleText
extends Style {
    private String font;
    private Double fontSize;
    private Boolean underline;
    private String color;
    private Boolean whitespacePre;

    private StyleText(Builder builder) {
        super(builder);
        this.font = builder.font;
        this.fontSize = builder.fontSize;
        this.underline = builder.underline;
        this.color = builder.color;
        this.whitespacePre = builder.whitespacePre;
    }

    public String getFont() {
        return this.font;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public Boolean getUnderline() {
        return this.underline;
    }

    public String getColor() {
        return this.color;
    }

    public Boolean getWhitespacePre() {
        return this.whitespacePre;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setWhitespacePre(Boolean whitespacePre) {
        this.whitespacePre = whitespacePre;
    }

    @Override
    public String toString() {
        return "StyleText(font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", underline=" + this.getUnderline() + ", color=" + this.getColor() + ", whitespacePre=" + this.getWhitespacePre() + ")";
    }

    public StyleText() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StyleText)) {
            return false;
        }
        StyleText other = (StyleText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$font = this.getFont();
        String other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Double this$fontSize = this.getFontSize();
        Double other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Boolean this$underline = this.getUnderline();
        Boolean other$underline = other.getUnderline();
        if (this$underline == null ? other$underline != null : !((Object)this$underline).equals(other$underline)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        Boolean this$whitespacePre = this.getWhitespacePre();
        Boolean other$whitespacePre = other.getWhitespacePre();
        return !(this$whitespacePre == null ? other$whitespacePre != null : !((Object)this$whitespacePre).equals(other$whitespacePre));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StyleText;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Double $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Boolean $underline = this.getUnderline();
        result = result * 59 + ($underline == null ? 43 : ((Object)$underline).hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        Boolean $whitespacePre = this.getWhitespacePre();
        result = result * 59 + ($whitespacePre == null ? 43 : ((Object)$whitespacePre).hashCode());
        return result;
    }

    public static class Builder
    extends Style.Builder<Builder> {
        private String font;
        private Double fontSize;
        private Boolean underline;
        private String color;
        private Boolean whitespacePre;

        public Builder font(String font) {
            this.font = font;
            return this;
        }

        public Builder fontSize(double size) {
            this.fontSize = size;
            return this;
        }

        public Builder underline(boolean underline) {
            this.underline = underline;
            return this;
        }

        public Builder color(Color color) {
            return this.color(Utils.colorToHex(color));
        }

        public Builder color(String color) {
            this.color = color;
            return this;
        }

        public Builder whitespacePre(boolean whitespacePre) {
            this.whitespacePre = whitespacePre;
            return this;
        }

        public StyleText build() {
            return new StyleText(this);
        }
    }
}

