/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.layers.feedforward.PReLU;
import org.deeplearning4j.nn.params.PReLUParamInitializer;
import org.deeplearning4j.nn.weights.WeightInitConstant;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class PReLULayer
extends BaseLayer {
    private long[] inputShape = null;
    private long[] sharedAxes = null;
    private int nIn;
    private int nOut;

    private PReLULayer(Builder builder) {
        super(builder);
        this.inputShape = builder.inputShape;
        this.sharedAxes = builder.sharedAxes;
        this.initializeConstraints(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        PReLU ret = new PReLU(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input type: null for layer name \"" + this.getLayerName() + "\"");
        }
        return inputType;
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return null;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        return false;
    }

    @Override
    public ParamInitializer initializer() {
        return PReLUParamInitializer.getInstance(this.inputShape, this.sharedAxes);
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        long numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize(numParams);
        return new LayerMemoryReport.Builder(this.layerName, PReLULayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, 0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public long[] getInputShape() {
        return this.inputShape;
    }

    public long[] getSharedAxes() {
        return this.sharedAxes;
    }

    public int getNIn() {
        return this.nIn;
    }

    public int getNOut() {
        return this.nOut;
    }

    public void setInputShape(long[] inputShape) {
        this.inputShape = inputShape;
    }

    public void setSharedAxes(long[] sharedAxes) {
        this.sharedAxes = sharedAxes;
    }

    public void setNIn(int nIn) {
        this.nIn = nIn;
    }

    public void setNOut(int nOut) {
        this.nOut = nOut;
    }

    public PReLULayer() {
    }

    @Override
    public String toString() {
        return "PReLULayer(super=" + super.toString() + ", inputShape=" + Arrays.toString(this.getInputShape()) + ", sharedAxes=" + Arrays.toString(this.getSharedAxes()) + ", nIn=" + this.getNIn() + ", nOut=" + this.getNOut() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PReLULayer)) {
            return false;
        }
        PReLULayer other = (PReLULayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getInputShape(), other.getInputShape())) {
            return false;
        }
        if (!Arrays.equals(this.getSharedAxes(), other.getSharedAxes())) {
            return false;
        }
        if (this.getNIn() != other.getNIn()) {
            return false;
        }
        return this.getNOut() == other.getNOut();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PReLULayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getInputShape());
        result = result * 59 + Arrays.hashCode(this.getSharedAxes());
        result = result * 59 + this.getNIn();
        result = result * 59 + this.getNOut();
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private long[] inputShape = null;
        private long[] sharedAxes = null;

        public Builder() {
            this.weightInitFn = new WeightInitConstant(0.0);
        }

        public Builder inputShape(long ... shape) {
            this.setInputShape(shape);
            return this;
        }

        public Builder sharedAxes(long ... axes) {
            this.setSharedAxes(axes);
            return this;
        }

        @Override
        public PReLULayer build() {
            return new PReLULayer(this);
        }

        public long[] getInputShape() {
            return this.inputShape;
        }

        public long[] getSharedAxes() {
            return this.sharedAxes;
        }

        public void setInputShape(long[] inputShape) {
            this.inputShape = inputShape;
        }

        public void setSharedAxes(long[] sharedAxes) {
            this.sharedAxes = sharedAxes;
        }
    }
}

