/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.datavec.api.records.reader.impl.csv.CSVSequenceRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.NumberedFileInputSplit;
import org.datavec.image.transform.ImageTransform;
import org.deeplearning4j.datasets.fetchers.CacheableExtractableDataSetFetcher;
import org.deeplearning4j.datasets.fetchers.DataSetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UciSequenceDataFetcher
extends CacheableExtractableDataSetFetcher {
    private static final Logger log = LoggerFactory.getLogger(UciSequenceDataFetcher.class);
    public static int NUM_LABELS = 6;
    public static int NUM_EXAMPLES = NUM_LABELS * 100;
    private static String url = "https://archive.ics.uci.edu/ml/machine-learning-databases/synthetic_control-mld/synthetic_control.data";

    public static void setURL(String url) {
        UciSequenceDataFetcher.url = url;
    }

    @Override
    public String remoteDataUrl() {
        return url;
    }

    @Override
    public String remoteDataUrl(DataSetType type) {
        return this.remoteDataUrl();
    }

    @Override
    public String localCacheName() {
        return "UCISequence_6";
    }

    @Override
    public long expectedChecksum() {
        return 104392751L;
    }

    @Override
    public long expectedChecksum(DataSetType type) {
        return this.expectedChecksum();
    }

    public CSVSequenceRecordReader getRecordReader(long rngSeed, int[] shape, DataSetType set, ImageTransform transform) {
        return this.getRecordReader(rngSeed, set);
    }

    public CSVSequenceRecordReader getRecordReader(long rngSeed, DataSetType set) {
        File dataPath;
        File localCache = this.getLocalCacheDir();
        UciSequenceDataFetcher.deleteIfEmpty(localCache);
        try {
            if (!localCache.exists()) {
                this.downloadAndExtract();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not download UCI Sequence data", e);
        }
        switch (set) {
            case TRAIN: {
                dataPath = new File(localCache, "/train");
                break;
            }
            case TEST: {
                dataPath = new File(localCache, "/test");
                break;
            }
            case VALIDATION: {
                throw new IllegalArgumentException("You will need to manually iterate the directory, UCISequence data does not provide labels");
            }
            default: {
                dataPath = new File(localCache, "/train");
            }
        }
        try {
            CSVSequenceRecordReader data;
            UciSequenceDataFetcher.downloadUCIData(dataPath);
            switch (set) {
                case TRAIN: {
                    data = new CSVSequenceRecordReader(0, ", ");
                    data.initialize((InputSplit)new NumberedFileInputSplit(dataPath.getAbsolutePath() + "/%d.csv", 0, 449));
                    break;
                }
                case TEST: {
                    data = new CSVSequenceRecordReader(0, ", ");
                    data.initialize((InputSplit)new NumberedFileInputSplit(dataPath.getAbsolutePath() + "/%d.csv", 450, 599));
                    break;
                }
                default: {
                    data = new CSVSequenceRecordReader(0, ", ");
                    data.initialize((InputSplit)new NumberedFileInputSplit(dataPath.getAbsolutePath() + "/%d.csv", 0, 449));
                }
            }
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process UCI data", e);
        }
    }

    private static void downloadUCIData(File dataPath) throws Exception {
        String data = IOUtils.toString((URL)new URL(url), (Charset)Charset.defaultCharset());
        String[] lines = data.split("\n");
        int lineCount = 0;
        int index = 0;
        ArrayList<CallSite> linesList = new ArrayList<CallSite>();
        for (String string : lines) {
            int count = lineCount++ / 100;
            String string3 = string.replaceAll("\\s+", ", " + count + "\n");
            string3 = string3 + ", " + count;
            linesList.add((CallSite)((Object)string3));
        }
        Collections.shuffle(linesList, new Random(12345L));
        for (String string : linesList) {
            File outPath = new File(dataPath, index + ".csv");
            FileUtils.writeStringToFile((File)outPath, (String)string, (Charset)Charset.defaultCharset());
            ++index;
        }
    }
}

