/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"columnIdxs", "inputSchema"})
public abstract class BaseColumnsMathOpTransform
implements Transform,
ColumnOp {
    protected final String newColumnName;
    protected final MathOp mathOp;
    protected final String[] columns;
    private int[] columnIdxs;
    private Schema inputSchema;

    public BaseColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("Invalid input: cannot have null/0 columns");
        }
        this.newColumnName = newColumnName;
        this.mathOp = mathOp;
        this.columns = columns;
        switch (mathOp) {
            case Add: {
                if (columns.length >= 2) break;
                throw new IllegalArgumentException("Need 2 or more columns for Add op. Got: " + Arrays.toString(columns));
            }
            case Subtract: {
                if (columns.length == 2) break;
                throw new IllegalArgumentException("Need exactly 2 columns for Subtract op. Got: " + Arrays.toString(columns));
            }
            case Multiply: {
                if (columns.length >= 2) break;
                throw new IllegalArgumentException("Need 2 or more columns for Multiply op. Got: " + Arrays.toString(columns));
            }
            case Divide: {
                if (columns.length == 2) break;
                throw new IllegalArgumentException("Need exactly 2 columns for Divide op. Got: " + Arrays.toString(columns));
            }
            case Modulus: {
                if (columns.length == 2) break;
                throw new IllegalArgumentException("Need exactly 2 columns for Modulus op. Got: " + Arrays.toString(columns));
            }
            case ReverseSubtract: 
            case ReverseDivide: 
            case ScalarMin: 
            case ScalarMax: {
                throw new IllegalArgumentException("Invalid MathOp: cannot use " + (Object)((Object)mathOp) + " with ...ColumnsMathOpTransform");
            }
            default: {
                throw new RuntimeException("Unknown MathOp: " + (Object)((Object)mathOp));
            }
        }
    }

    @Override
    public Schema transform(Schema inputSchema) {
        for (String name : this.columns) {
            if (inputSchema.hasColumn(name)) continue;
            throw new IllegalStateException("Input schema does not have column with name \"" + name + "\"");
        }
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(inputSchema.getColumnMetaData());
        newMeta.add(this.derivedColumnMetaData(this.newColumnName, inputSchema));
        return inputSchema.newSchema(newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.columnIdxs = new int[this.columns.length];
        int i = 0;
        for (String name : this.columns) {
            if (!inputSchema.hasColumn(name)) {
                throw new IllegalStateException("Input schema does not have column with name \"" + name + "\"");
            }
            this.columnIdxs[i++] = inputSchema.getIndexOfColumn(name);
        }
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (this.inputSchema == null) {
            throw new IllegalStateException("Input schema has not been set");
        }
        ArrayList<Writable> out = new ArrayList<Writable>(writables);
        Writable[] temp = new Writable[this.columns.length];
        for (int i = 0; i < this.columnIdxs.length; ++i) {
            temp[i] = (Writable)out.get(this.columnIdxs[i]);
        }
        out.add(this.doOp(temp));
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    @Override
    public String outputColumnName() {
        return this.newColumnName;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.newColumnName};
    }

    @Override
    public String[] columnNames() {
        return this.columns;
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    protected abstract ColumnMetaData derivedColumnMetaData(String var1, Schema var2);

    protected abstract Writable doOp(Writable ... var1);

    public abstract String toString();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseColumnsMathOpTransform)) {
            return false;
        }
        BaseColumnsMathOpTransform other = (BaseColumnsMathOpTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        if (this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName)) {
            return false;
        }
        MathOp this$mathOp = this.getMathOp();
        MathOp other$mathOp = other.getMathOp();
        if (this$mathOp == null ? other$mathOp != null : !((Object)((Object)this$mathOp)).equals((Object)other$mathOp)) {
            return false;
        }
        return Arrays.deepEquals(this.getColumns(), other.getColumns());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseColumnsMathOpTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        MathOp $mathOp = this.getMathOp();
        result = result * 59 + ($mathOp == null ? 43 : ((Object)((Object)$mathOp)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColumns());
        return result;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public MathOp getMathOp() {
        return this.mathOp;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public int[] getColumnIdxs() {
        return this.columnIdxs;
    }

    public void setColumnIdxs(int[] columnIdxs) {
        this.columnIdxs = columnIdxs;
    }
}

