/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.filter;

import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"schema", "columnIdxs"})
public class FilterInvalidValues
implements Filter {
    private Schema schema;
    private final boolean filterAnyInvalid;
    private final String[] columnsToFilterIfInvalid;
    private int[] columnIdxs;

    public FilterInvalidValues() {
        this.filterAnyInvalid = true;
        this.columnsToFilterIfInvalid = null;
    }

    public FilterInvalidValues(String ... columnsToFilterIfInvalid) {
        if (columnsToFilterIfInvalid == null || columnsToFilterIfInvalid.length == 0) {
            throw new IllegalArgumentException("Cannot filter 0/null columns: columns to filter on must be specified");
        }
        this.columnsToFilterIfInvalid = columnsToFilterIfInvalid;
        this.filterAnyInvalid = false;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.schema = schema;
        if (!this.filterAnyInvalid) {
            this.columnIdxs = new int[this.columnsToFilterIfInvalid.length];
            for (int i = 0; i < this.columnsToFilterIfInvalid.length; ++i) {
                this.columnIdxs[i] = schema.getIndexOfColumn(this.columnsToFilterIfInvalid[i]);
            }
        }
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public boolean removeExample(Object writables) {
        List row = (List)writables;
        if (!this.filterAnyInvalid) {
            for (int i : this.columnIdxs) {
                if (!this.filterColumn(row, i)) continue;
                return true;
            }
        } else {
            int nCols = this.schema.numColumns();
            for (int i = 0; i < nCols; ++i) {
                if (!this.filterColumn(row, i)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterColumn(List<?> row, int i) {
        ColumnMetaData meta = this.schema.getMetaData(i);
        return row.get(i) instanceof Float ? !meta.isValid(new FloatWritable(((Float)row.get(i)).floatValue())) : (row.get(i) instanceof Double ? !meta.isValid(new DoubleWritable((Double)row.get(i))) : (row.get(i) instanceof String ? !meta.isValid(new Text(((String)row.get(i)).toString())) : (row.get(i) instanceof Integer ? !meta.isValid(new IntWritable((Integer)row.get(i))) : (row.get(i) instanceof Long ? !meta.isValid(new LongWritable((Long)row.get(i))) : row.get(i) instanceof Boolean && !meta.isValid(new BooleanWritable((Boolean)row.get(i)))))));
    }

    @Override
    public boolean removeSequence(Object sequence) {
        List seq = (List)sequence;
        for (Object c : seq) {
            if (!this.removeExample(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeExample(List<Writable> writables) {
        if (writables.size() != this.schema.numColumns()) {
            return true;
        }
        if (!this.filterAnyInvalid) {
            for (int i : this.columnIdxs) {
                ColumnMetaData meta = this.schema.getMetaData(i);
                if (meta.isValid(writables.get(i))) continue;
                return true;
            }
        } else {
            int nCols = this.schema.numColumns();
            for (int i = 0; i < nCols; ++i) {
                ColumnMetaData meta = this.schema.getMetaData(i);
                if (meta.isValid(writables.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeSequence(List<List<Writable>> sequence) {
        for (List<Writable> c : sequence) {
            if (!this.removeExample(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return this.columnNames();
    }

    @Override
    public String[] columnNames() {
        return this.schema.getColumnNames().toArray(new String[this.schema.numColumns()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterInvalidValues)) {
            return false;
        }
        FilterInvalidValues other = (FilterInvalidValues)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFilterAnyInvalid() != other.isFilterAnyInvalid()) {
            return false;
        }
        return Arrays.deepEquals(this.getColumnsToFilterIfInvalid(), other.getColumnsToFilterIfInvalid());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterInvalidValues;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFilterAnyInvalid() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getColumnsToFilterIfInvalid());
        return result;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean isFilterAnyInvalid() {
        return this.filterAnyInvalid;
    }

    public String[] getColumnsToFilterIfInvalid() {
        return this.columnsToFilterIfInvalid;
    }

    public int[] getColumnIdxs() {
        return this.columnIdxs;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setColumnIdxs(int[] columnIdxs) {
        this.columnIdxs = columnIdxs;
    }

    public String toString() {
        return "FilterInvalidValues(filterAnyInvalid=" + this.isFilterAnyInvalid() + ", columnsToFilterIfInvalid=" + Arrays.deepToString(this.getColumnsToFilterIfInvalid()) + ")";
    }
}

