/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.quality.QualityAnalysisState;
import org.datavec.api.transform.analysis.quality.bytes.BytesQualityAnalysisState;
import org.datavec.api.transform.analysis.quality.categorical.CategoricalQualityAnalysisState;
import org.datavec.api.transform.analysis.quality.integer.IntegerQualityAnalysisState;
import org.datavec.api.transform.analysis.quality.longq.LongQualityAnalysisState;
import org.datavec.api.transform.analysis.quality.real.RealQualityAnalysisState;
import org.datavec.api.transform.analysis.quality.string.StringQualityAnalysisState;
import org.datavec.api.transform.analysis.quality.time.TimeQualityAnalysisState;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.common.function.BiFunction;

public class QualityAnalysisAddFunction
implements BiFunction<List<QualityAnalysisState>, List<Writable>, List<QualityAnalysisState>>,
Serializable {
    private Schema schema;

    public List<QualityAnalysisState> apply(List<QualityAnalysisState> analysisStates, List<Writable> writables) {
        int size;
        if (analysisStates == null) {
            analysisStates = new ArrayList<QualityAnalysisState>();
            List<ColumnType> columnTypes = this.schema.getColumnTypes();
            List<ColumnMetaData> columnMetaDatas = this.schema.getColumnMetaData();
            block9: for (int i = 0; i < columnTypes.size(); ++i) {
                switch (columnTypes.get(i)) {
                    case String: {
                        analysisStates.add(new StringQualityAnalysisState((StringMetaData)columnMetaDatas.get(i)));
                        continue block9;
                    }
                    case Integer: {
                        analysisStates.add(new IntegerQualityAnalysisState((IntegerMetaData)columnMetaDatas.get(i)));
                        continue block9;
                    }
                    case Long: {
                        analysisStates.add(new LongQualityAnalysisState((LongMetaData)columnMetaDatas.get(i)));
                        continue block9;
                    }
                    case Double: {
                        analysisStates.add(new RealQualityAnalysisState((DoubleMetaData)columnMetaDatas.get(i)));
                        continue block9;
                    }
                    case Categorical: {
                        analysisStates.add(new CategoricalQualityAnalysisState((CategoricalMetaData)columnMetaDatas.get(i)));
                        continue block9;
                    }
                    case Time: {
                        analysisStates.add(new TimeQualityAnalysisState((TimeMetaData)columnMetaDatas.get(i)));
                        continue block9;
                    }
                    case Bytes: {
                        analysisStates.add(new BytesQualityAnalysisState());
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown column type: " + (Object)((Object)columnTypes.get(i)));
                    }
                }
            }
        }
        if ((size = analysisStates.size()) != writables.size()) {
            throw new IllegalStateException("Writables list and number of states does not match (" + writables.size() + " vs " + size + ")");
        }
        for (int i = 0; i < size; ++i) {
            analysisStates.get(i).add(writables.get(i));
        }
        return analysisStates;
    }

    public QualityAnalysisAddFunction(Schema schema) {
        this.schema = schema;
    }
}

