/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.histogram;

import org.datavec.api.transform.analysis.histogram.HistogramCounter;
import org.datavec.api.writable.Writable;

public class StringHistogramCounter
implements HistogramCounter {
    private final int minLength;
    private final int maxLength;
    private final int nBins;
    private final double[] bins;
    private final long[] binCounts;

    public StringHistogramCounter(int minLength, int maxLength, int nBins) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.nBins = nBins;
        this.bins = new double[nBins + 1];
        double step = (double)(maxLength - minLength) / (double)nBins;
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = i == this.bins.length - 1 ? (double)maxLength : (double)i * step;
        }
        this.binCounts = new long[nBins];
    }

    @Override
    public HistogramCounter add(Writable w) {
        double d = w.toString().length();
        int idx = -1;
        for (int i = 0; i < this.nBins; ++i) {
            if (!(d >= this.bins[i]) || !(d < this.bins[i])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            idx = this.nBins - 1;
        }
        int n = idx;
        this.binCounts[n] = this.binCounts[n] + 1L;
        return this;
    }

    @Override
    public StringHistogramCounter merge(HistogramCounter other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof StringHistogramCounter)) {
            throw new IllegalArgumentException("Cannot merge " + other);
        }
        StringHistogramCounter o = (StringHistogramCounter)other;
        if (this.minLength != o.minLength || this.maxLength != o.maxLength) {
            throw new IllegalStateException("Min/max values differ: (" + this.minLength + "," + this.maxLength + ")  vs. (" + o.minLength + "," + o.maxLength + ")");
        }
        if (this.nBins != o.nBins) {
            throw new IllegalStateException("Different number of bins: " + this.nBins + " vs " + o.nBins);
        }
        for (int i = 0; i < this.nBins; ++i) {
            int n = i;
            this.binCounts[n] = this.binCounts[n] + o.binCounts[i];
        }
        return this;
    }

    @Override
    public double[] getBins() {
        return this.bins;
    }

    @Override
    public long[] getCounts() {
        return this.binCounts;
    }
}

