/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.datavec.api.split.InputSplit;

public class InputStreamInputSplit
implements InputSplit {
    private InputStream is;
    private URI[] location;

    public InputStreamInputSplit(InputStream is, String path) {
        this(is, URI.create(path));
    }

    public InputStreamInputSplit(InputStream is, File path) {
        this(is, path.toURI());
    }

    public InputStreamInputSplit(InputStream is, URI path) {
        this.is = is;
        this.location = new URI[]{path};
    }

    public InputStreamInputSplit(InputStream is) {
        this.is = is;
        this.location = new URI[0];
    }

    @Override
    public boolean canWriteToLocation(URI location) {
        return false;
    }

    @Override
    public String addNewLocation() {
        return null;
    }

    @Override
    public String addNewLocation(String location) {
        return null;
    }

    @Override
    public void updateSplitLocations(boolean reset) {
    }

    @Override
    public boolean needsBootstrapForWrite() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bootStrapForWrite() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStreamFor(String location) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openInputStreamFor(String location) throws Exception {
        return this.is;
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI[] locations() {
        return this.location;
    }

    @Override
    public Iterator<URI> locationsIterator() {
        return Collections.singletonList(this.location[0]).iterator();
    }

    @Override
    public Iterator<String> locationsPathIterator() {
        if (this.location.length >= 1) {
            return Collections.singletonList(this.location[0].getPath()).iterator();
        }
        return Arrays.asList("").iterator();
    }

    @Override
    public void reset() {
        if (!this.resetSupported()) {
            throw new UnsupportedOperationException("Reset not supported from streams");
        }
        try {
            this.is = this.openInputStreamFor(this.location[0].getPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean resetSupported() {
        return this.location != null && this.location.length > 0;
    }

    public InputStream getIs() {
        return this.is;
    }

    public void setIs(InputStream is) {
        this.is = is;
    }
}

