/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.EnhancerClassLoader;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassEnhancer
implements ClassEnhancer {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected final ClassLoaderResolver clr;
    protected final MetaDataManager metaDataMgr;
    protected final ClassMetaData cmd;
    public final String className;
    protected boolean update = false;
    protected List<ClassField> fieldsToAdd = new ArrayList<ClassField>();
    protected List<ClassMethod> methodsToAdd = new ArrayList<ClassMethod>();
    protected boolean initialised = false;
    protected Collection<String> options = new HashSet<String>();

    public AbstractClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr, MetaDataManager mmgr) {
        this.clr = clr;
        this.cmd = cmd;
        this.className = cmd.getFullClassName();
        this.metaDataMgr = mmgr;
    }

    protected void initialise() {
        if (this.initialised) {
            return;
        }
        this.initialiseFieldsList();
        this.initialiseMethodsList();
        this.initialised = true;
    }

    protected abstract void initialiseMethodsList();

    protected abstract void initialiseFieldsList();

    public List<ClassMethod> getMethodsList() {
        return this.methodsToAdd;
    }

    public List<ClassField> getFieldsList() {
        return this.fieldsToAdd;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.metaDataMgr;
    }

    @Override
    public ClassMetaData getClassMetaData() {
        return this.cmd;
    }

    protected boolean requiresDetachable() {
        boolean hasPcsc;
        boolean isDetachable = this.cmd.isDetachable();
        boolean bl = hasPcsc = this.cmd.getPersistenceCapableSuperclass() != null;
        if (!hasPcsc && isDetachable) {
            return true;
        }
        return hasPcsc && !this.cmd.getSuperAbstractClassMetaData().isDetachable() && isDetachable;
    }

    public boolean isPersistenceCapable(String className) {
        if (className.equals(this.className) && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return true;
        }
        OMFContext omfCtx = this.metaDataMgr.getOMFContext();
        Class cls = this.clr.classForName(className, (ClassLoader)new EnhancerClassLoader());
        if (omfCtx.getApiAdapter().isPersistable(cls)) {
            return true;
        }
        AbstractClassMetaData cmd = this.metaDataMgr.getMetaDataForClass(cls, this.clr);
        return cmd != null && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    }

    @Override
    public void setOptions(Collection<String> options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        this.options.addAll(options);
    }

    @Override
    public boolean hasOption(String name) {
        return this.options.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String directoryName) throws IOException {
        if (!this.update) {
            return;
        }
        File classFile = null;
        File pkClassFile = null;
        if (directoryName != null) {
            File baseDir = new File(directoryName);
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            } else if (!baseDir.isDirectory()) {
                throw new RuntimeException("Target directory " + directoryName + " is not a directory");
            }
            String sep = System.getProperty("file.separator");
            String baseName = this.cmd.getFullClassName().replace('.', sep.charAt(0));
            classFile = new File(directoryName, baseName + ".class");
            classFile.getParentFile().mkdirs();
            if (this.getPrimaryKeyClassBytes() != null) {
                pkClassFile = new File(directoryName, baseName + AbstractClassMetaData.GENERATED_PK_SUFFIX + ".class");
            }
        } else {
            String baseName = this.className.replace('.', '/');
            URL classURL = this.clr.getResource(baseName + ".class", null);
            URL convertedPath = this.metaDataMgr.getOMFContext().getPluginManager().resolveURLAsFileURL(classURL);
            String classFilename = convertedPath.getFile();
            classFile = StringUtils.getFileForFilename((String)classFilename);
            String pkClassFilename = classFilename.substring(0, classFilename.length() - 6) + AbstractClassMetaData.GENERATED_PK_SUFFIX + ".class";
            pkClassFile = StringUtils.getFileForFilename((String)pkClassFilename);
        }
        FileOutputStream out = null;
        try {
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.WriteClass", (Object)classFile));
            out = new FileOutputStream(classFile);
            out.write(this.getClassBytes());
        }
        finally {
            try {
                out.close();
                out = null;
            }
            catch (Exception ignore) {}
        }
        byte[] pkClassBytes = this.getPrimaryKeyClassBytes();
        if (pkClassBytes != null) {
            try {
                DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.WritePrimaryKeyClass", (Object)pkClassFile));
                out = new FileOutputStream(pkClassFile);
                out.write(pkClassBytes);
            }
            finally {
                try {
                    out.close();
                    out = null;
                }
                catch (Exception ignore) {}
            }
        }
    }
}

