/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelDispatcher<OUTPUT> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelDispatcher.class);
    private final Channel[] channels;

    public ChannelDispatcher(List<Channel> tokenizers) {
        this.channels = tokenizers.toArray(new Channel[0]);
    }

    public void consum(CodeReader code, OUTPUT output) {
        int nextChar = code.peek();
        while (nextChar != -1) {
            boolean channelConsumed = false;
            for (Channel channel : this.channels) {
                if (!channel.consum(code, output)) continue;
                channelConsumed = true;
                break;
            }
            if (!channelConsumed) {
                logger.debug("None of the channel is able to handle character '" + code.peek() + "' at line " + code.getLinePosition() + ", column " + code.getColumnPosition());
                code.pop();
            }
            nextChar = code.peek();
        }
    }
}

