/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.codehaus.mojo.webstart.AbstractJnlpMojo;
import org.codehaus.mojo.webstart.JnlpExtension;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends AbstractGenerator {
    private AbstractJnlpMojo config;

    public Generator(Log log, MavenProject mavenProject, AbstractJnlpMojo task, String defaultTemplateResourceName, File resourceLoaderPath, File outputFile, String inputFileTemplatePath, String mainClass, String webstartJarURL, String encoding) {
        super(log, mavenProject, resourceLoaderPath, defaultTemplateResourceName, outputFile, inputFileTemplatePath, mainClass, webstartJarURL, encoding);
        this.config = task;
    }

    @Override
    protected String getDependenciesText() {
        return this.indentText(4, Generator.getDependenciesText(this.config));
    }

    @Override
    protected VelocityContext createAndPopulateContext() {
        VelocityContext context = super.createAndPopulateContext();
        if (this.config.hasJnlpExtensions()) {
            context.put("extensions", (Object)this.indentText(4, Generator.getExtensionsText(this.config)));
        }
        return context;
    }

    static String getDependenciesText(AbstractJnlpMojo config) {
        return Generator.getDependenciesText(config, config.getPackagedJnlpArtifacts());
    }

    static String getDependenciesText(AbstractJnlpMojo config, List<Artifact> artifacts) {
        String dependenciesText = "";
        if (artifacts.size() != 0) {
            StringBuilder buffer = new StringBuilder(100 * artifacts.size());
            buffer.append("\n");
            if (config.isPack200()) {
                buffer.append("<property name=\"jnlp.packEnabled\" value=\"true\" />\n");
            }
            if (config.isOutputJarVersions()) {
                buffer.append("<property name=\"jnlp.versionEnabled\" value=\"true\" />\n");
            }
            String jarLibPath = null;
            if (config.getLibPath() != null) {
                jarLibPath = config.getLibPath();
                jarLibPath = jarLibPath != null && jarLibPath.trim().length() != 0 ? jarLibPath.trim() : null;
            }
            for (Artifact artifact : artifacts) {
                buffer.append("<jar href=\"");
                if (jarLibPath != null) {
                    buffer.append(jarLibPath).append("/");
                }
                String filename = artifact.getFile().getName();
                if (config.isOutputJarVersions()) {
                    String extension = filename.substring(filename.lastIndexOf("."));
                    buffer.append(artifact.getArtifactId()).append(extension).append("\"");
                    buffer.append(" version=\"").append(artifact.getVersion()).append("\"");
                } else {
                    buffer.append(filename).append("\"");
                }
                if (config.isArtifactWithMainClass(artifact)) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>\n");
            }
            dependenciesText = buffer.toString();
        }
        return dependenciesText;
    }

    static String getExtensionsText(AbstractJnlpMojo config) {
        String text = "";
        List<JnlpExtension> extensions = config.getJnlpExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            StringBuilder buffer = new StringBuilder(100 * extensions.size());
            buffer.append("\n");
            for (JnlpExtension extension : extensions) {
                buffer.append("<extension name=\"");
                buffer.append(extension.getName());
                buffer.append("\" href=\"");
                buffer.append(extension.getOutputFile());
                buffer.append("\"/>\n");
            }
            text = buffer.toString();
        }
        return text;
    }
}

