/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="compare-dependencies", threadSafe=true)
public class CompareDependenciesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private static final int INFO_PAD_SIZE = 68;
    @Parameter(property="remotePom", required=true)
    protected String remotePom;
    @Parameter(property="ignoreRemoteDependencies", defaultValue="false")
    protected boolean ignoreRemoteDependencies;
    @Parameter(property="ignoreRemoteDependencyManagement", defaultValue="false")
    protected boolean ignoreRemoteDependencyManagement;
    @Parameter(property="updateDependencies", defaultValue="false")
    protected boolean updateDependencies;
    @Parameter(property="updatePropertyVersions", defaultValue="false")
    protected boolean updatePropertyVersions;
    @Parameter(property="reportMode", defaultValue="true")
    protected boolean reportMode;
    @Parameter(property="reportOutputFile")
    protected File reportOutputFile;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies = true;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement = true;
    @Parameter(property="processParent", defaultValue="false")
    private boolean processParent = false;
    protected final ProjectBuilder projectBuilder;

    @Inject
    public CompareDependenciesMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, ProjectBuilder projectBuilder, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
        this.projectBuilder = projectBuilder;
    }

    @Override
    protected boolean getProcessDependencies() {
        return this.processDependencies;
    }

    @Override
    protected boolean getProcessDependencyManagement() {
        return this.processDependencyManagement;
    }

    @Override
    public boolean getProcessParent() {
        return this.processParent;
    }

    @Override
    protected boolean getAllowSnapshots() {
        return true;
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        String[] remoteGAV;
        if (this.ignoreRemoteDependencies && this.ignoreRemoteDependencyManagement) {
            throw new MojoFailureException(" ignoreRemoteDependencies and ignoreRemoteDependencyManagement are both set to true.  At least one of these needs to be false ");
        }
        if (this.updateDependencies) {
            this.reportMode = false;
        }
        if ((remoteGAV = this.remotePom.split(":")).length != 3) {
            throw new MojoFailureException(" Invalid format for remotePom: " + this.remotePom);
        }
        MavenProject remoteMavenProject = null;
        try {
            remoteMavenProject = this.getRemoteMavenProject(remoteGAV[0], remoteGAV[1], remoteGAV[2]);
        }
        catch (ArtifactResolutionException | ProjectBuildingException e) {
            throw new MojoFailureException(e.getMessage());
        }
        HashMap<String, Dependency> remoteDepsMap = new HashMap<String, Dependency>();
        if (!this.ignoreRemoteDependencyManagement) {
            List remoteProjectDepMgmtDeps;
            List list = remoteProjectDepMgmtDeps = remoteMavenProject.getDependencyManagement() == null ? null : remoteMavenProject.getDependencyManagement().getDependencies();
            if (remoteProjectDepMgmtDeps != null) {
                remoteProjectDepMgmtDeps.forEach(dep -> remoteDepsMap.putIfAbsent(dep.getManagementKey(), (Dependency)dep));
            }
        }
        if (!this.ignoreRemoteDependencies && remoteMavenProject.getDependencies() != null) {
            remoteMavenProject.getDependencies().forEach(dep -> remoteDepsMap.putIfAbsent(dep.getManagementKey(), (Dependency)dep));
        }
        ArrayList<String> totalDiffs = new ArrayList<String>();
        ArrayList<String> propertyDiffs = new ArrayList<String>();
        if (this.getProject().getDependencyManagement() != null && this.getProcessDependencyManagement()) {
            totalDiffs.addAll(this.compareVersions(pom, this.getProject().getDependencyManagement().getDependencies(), remoteDepsMap, DependencyChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT));
        }
        if (this.getProject().getDependencies() != null && this.getProcessDependencies()) {
            totalDiffs.addAll(this.compareVersions(pom, this.getProject().getDependencies(), remoteDepsMap, DependencyChangeRecord.ChangeKind.DEPENDENCY));
        }
        if (this.updatePropertyVersions) {
            Map versionProperties = this.getHelper().getVersionPropertiesMap(VersionsHelper.VersionPropertiesMapRequest.builder().withMavenProject(this.getProject()).build());
            propertyDiffs.addAll(this.updatePropertyVersions(pom, versionProperties, remoteDepsMap));
        }
        if (this.getProject().getParent() != null && remoteMavenProject.getParent() != null && this.getProcessParent()) {
            Dependency parent = DependencyBuilder.newBuilder().withGroupId(remoteMavenProject.getParentArtifact().getGroupId()).withArtifactId(remoteMavenProject.getParentArtifact().getArtifactId()).withVersion(remoteMavenProject.getParentArtifact().getVersion()).withType(remoteMavenProject.getParentArtifact().getType()).withScope(remoteMavenProject.getParentArtifact().getScope()).withClassifier(remoteMavenProject.getParentArtifact().getClassifier()).build();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Processing parent dependency: " + parent));
            }
            remoteDepsMap.putIfAbsent(parent.getManagementKey(), parent);
            totalDiffs.addAll(this.compareVersions(pom, Collections.singletonList(this.getParentDependency()), remoteDepsMap, DependencyChangeRecord.ChangeKind.PARENT));
        }
        if (this.reportMode) {
            this.getLog().info((CharSequence)"The following differences were found:");
            if (totalDiffs.isEmpty()) {
                this.getLog().info((CharSequence)"  none");
            } else {
                for (String totalDiff : totalDiffs) {
                    this.getLog().info((CharSequence)("  " + totalDiff));
                }
            }
            this.getLog().info((CharSequence)"The following property differences were found:");
            if (propertyDiffs.isEmpty()) {
                this.getLog().info((CharSequence)"  none");
            } else {
                for (String propertyDiff : propertyDiffs) {
                    this.getLog().info((CharSequence)("  " + propertyDiff));
                }
            }
        }
        if (this.reportOutputFile != null) {
            this.writeReportFile(totalDiffs, propertyDiffs);
        }
    }

    private MavenProject getRemoteMavenProject(String groupId, String artifactId, String version) throws MojoExecutionException, ArtifactResolutionException, ProjectBuildingException {
        Artifact remoteArtifact = this.toArtifact(DependencyBuilder.newBuilder().withGroupId(groupId).withArtifactId(artifactId).withVersion(version).build());
        ProjectBuildingResult result = this.projectBuilder.build(remoteArtifact, true, PomHelper.createProjectBuilderRequest((MavenSession)this.session, (Consumer[])new Consumer[]{r -> r.setProcessPlugins(false), r -> r.setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories()), r -> r.setPluginArtifactRepositories(this.session.getCurrentProject().getPluginArtifactRepositories())}));
        if (!result.getProblems().isEmpty()) {
            this.getLog().warn((CharSequence)("Problems encountered during construction of the POM for " + remoteArtifact.toString()));
            result.getProblems().forEach(p -> this.getLog().warn((CharSequence)("\t" + p.getMessage())));
        }
        return result.getProject();
    }

    private List<String> compareVersions(MutableXMLStreamReader pom, List<Dependency> dependencies, Map<String, Dependency> remoteDependencies, DependencyChangeRecord.ChangeKind changeKind) throws MojoExecutionException, XMLStreamException {
        ArrayList<String> updates = new ArrayList<String>();
        for (Dependency dep : dependencies) {
            String remoteVersion;
            Dependency remoteDep;
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact) || (remoteDep = remoteDependencies.get(dep.getManagementKey())) == null || Objects.equals(remoteVersion = remoteDep.getVersion(), dep.getVersion())) continue;
            StringBuilder buf = this.writeDependencyDiffMessage(dep, remoteVersion);
            updates.add(buf.toString());
            if (this.reportMode) continue;
            this.updateDependencyVersion(pom, dep, remoteVersion, changeKind);
        }
        return updates;
    }

    private List<String> updatePropertyVersions(MutableXMLStreamReader pom, Map<Property, PropertyVersions> versionProperties, Map<String, Dependency> remoteDependencies) throws XMLStreamException {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Property, PropertyVersions> entry : versionProperties.entrySet()) {
            String originalVersion;
            PropertyVersions version;
            Property property = entry.getKey();
            String candidateVersion = this.computeCandidateVersion(remoteDependencies, property, version = entry.getValue());
            if (candidateVersion == null || candidateVersion.equals(originalVersion = version.getAssociations()[0].getArtifact().getVersion())) continue;
            result.add(this.writeDiffMessage(property.getName(), originalVersion, candidateVersion).toString());
            if (this.reportMode || !PomHelper.setPropertyVersion((MutableXMLStreamReader)pom, null, (String)property.getName(), (String)candidateVersion)) continue;
            this.getLog().info((CharSequence)("Updated ${" + property.getName() + "} from " + originalVersion + " to " + candidateVersion));
        }
        return result;
    }

    private String computeCandidateVersion(Map<String, Dependency> remoteDependencies, Property property, PropertyVersions propertyVersions) {
        String candidateVersion = null;
        for (ArtifactAssociation artifactAssociation : propertyVersions.getAssociations()) {
            String id = CompareDependenciesMojo.generateId(artifactAssociation.getArtifact());
            Dependency dependency = remoteDependencies.get(id);
            if (dependency == null) {
                this.getLog().info((CharSequence)("Not updating ${" + property.getName() + "}: no info for " + id));
                return null;
            }
            if (candidateVersion == null) {
                candidateVersion = dependency.getVersion();
                continue;
            }
            if (candidateVersion.equals(dependency.getVersion())) continue;
            this.getLog().warn((CharSequence)("Could not update ${" + property.getName() + "}: version mismatch"));
            return null;
        }
        return candidateVersion;
    }

    private void writeReportFile(List<String> dependenciesUpdate, List<String> propertiesUpdate) throws MojoExecutionException {
        if (!this.reportOutputFile.getParentFile().exists()) {
            this.reportOutputFile.getParentFile().mkdirs();
        }
        try (FileWriter fw = new FileWriter(this.reportOutputFile);
             PrintWriter pw = new PrintWriter(fw);){
            pw.println("The following differences were found:");
            pw.println();
            if (dependenciesUpdate.isEmpty()) {
                pw.println("  none");
            } else {
                for (String dependencyUpdate : dependenciesUpdate) {
                    pw.println("  " + dependencyUpdate);
                }
            }
            pw.println();
            pw.println("The following property differences were found:");
            pw.println();
            if (propertiesUpdate.isEmpty()) {
                pw.println("  none");
            } else {
                for (String propertyUpdate : propertiesUpdate) {
                    pw.println("  " + propertyUpdate);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write report file. ", (Exception)e);
        }
    }

    private StringBuilder writeDependencyDiffMessage(Dependency dep, String remoteVersion) {
        String id = dep.getGroupId() + ":" + dep.getArtifactId();
        return this.writeDiffMessage(id, Optional.ofNullable(dep.getVersion()).orElse("(no version)"), Optional.ofNullable(remoteVersion).orElse("(no version)"));
    }

    private StringBuilder writeDiffMessage(String id, String originalVersion, String targetVersion) {
        StringBuilder buf = new StringBuilder();
        buf.append(id);
        buf.append(' ');
        int padding = 68 - originalVersion.length() - targetVersion.length() - 4;
        while (buf.length() < padding) {
            buf.append('.');
        }
        buf.append(' ');
        buf.append(originalVersion);
        buf.append(" -> ");
        buf.append(targetVersion);
        return buf;
    }

    private static String generateId(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getType());
        if (artifact.getClassifier() != null) {
            sb.append(":").append(artifact.getClassifier());
        }
        return sb.toString();
    }
}

