/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven.sysvpkg;

import fj.F2;
import fj.Unit;
import fj.data.List;
import fj.data.Option;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.FileCollector;
import org.codehaus.mojo.unix.PackageParameters;
import org.codehaus.mojo.unix.PackageVersion;
import org.codehaus.mojo.unix.UnixFsObject;
import org.codehaus.mojo.unix.UnixPackage;
import org.codehaus.mojo.unix.sysvpkg.PkginfoFile;
import org.codehaus.mojo.unix.sysvpkg.PkgmkCommand;
import org.codehaus.mojo.unix.sysvpkg.PkgtransCommand;
import org.codehaus.mojo.unix.sysvpkg.prototype.DirectoryEntry;
import org.codehaus.mojo.unix.sysvpkg.prototype.PrototypeFile;
import org.codehaus.mojo.unix.util.RelativePath;
import org.codehaus.mojo.unix.util.ScriptUtil;
import org.codehaus.mojo.unix.util.line.LineProducer;
import org.codehaus.mojo.unix.util.line.LineStreamUtil;
import org.codehaus.mojo.unix.util.vfs.VfsUtil;
import org.codehaus.plexus.util.IOUtil;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkgUnixPackage
extends UnixPackage {
    private FileObject workingDirectory;
    private FileObject prototype;
    private FileObject pkginfo;
    private boolean debug;
    private static final ScriptUtil scriptUtil = new ScriptUtil("preinstall", "postinstall", "preremove", "postremove").customScript("depend").customScript("checkinstall").customScript("compver").customScript("copyright").customScript("request").customScript("space");
    private PrototypeFile prototypeFile;
    private PkginfoFile pkginfoFile;
    private List<Callable> operations = List.nil();
    private Option<String> classifier = Option.none();

    public PkgUnixPackage() {
        super("pkg");
    }

    public UnixPackage parameters(PackageParameters parameters) {
        this.classifier = parameters.classifier;
        this.pkginfoFile = new PkginfoFile((String)parameters.architecture.orSome((Object)"all"), "application", parameters.name, parameters.id, PkgUnixPackage.getPkgVersion(parameters.version)).desc(parameters.description).email(parameters.contactEmail).pstamp(Option.some((Object)parameters.version.timestamp)).email(parameters.contactEmail);
        return this;
    }

    public UnixPackage workingDirectory(FileObject workingDirectory) throws FileSystemException {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public UnixPackage debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes) throws IOException {
        this.prototype = this.workingDirectory.resolveFile("prototype");
        this.pkginfo = this.workingDirectory.resolveFile("pkginfo");
        UnixFsObject.Directory defaultDirectory = UnixFsObject.directory((RelativePath)RelativePath.BASE, (LocalDateTime)LocalDateTime.fromDateFields((Date)new Date(0L)), (FileAttributes)defaultDirectoryAttributes);
        DirectoryEntry directoryEntry = new DirectoryEntry(Option.none(), defaultDirectory);
        this.prototypeFile = new PrototypeFile(directoryEntry);
    }

    public PkgUnixPackage pkgParameters(List<String> classes, Option<String> category) {
        this.pkginfoFile = this.pkginfoFile.category((String)category.orSome((Object)this.pkginfoFile.category)).classes(classes);
        return this;
    }

    public void packageToFile(File packageFile, ScriptUtil.Strategy strategy) throws Exception {
        RelativePath[] specialPaths;
        for (RelativePath specialPath : specialPaths = new RelativePath[]{RelativePath.BASE, RelativePath.relativePath((String)"/etc"), RelativePath.relativePath((String)"/etc/opt"), RelativePath.relativePath((String)"/opt"), RelativePath.relativePath((String)"/usr"), RelativePath.relativePath((String)"/var"), RelativePath.relativePath((String)"/var/opt")}) {
            if (!this.prototypeFile.hasPath(specialPath)) continue;
            this.prototypeFile.addDirectory(UnixFsObject.directory((RelativePath)specialPath, (LocalDateTime)new LocalDateTime(), (FileAttributes)FileAttributes.EMPTY));
        }
        File workingDirectoryF = VfsUtil.asFile((FileObject)this.workingDirectory);
        File pkginfoF = VfsUtil.asFile((FileObject)this.pkginfo);
        File prototypeF = VfsUtil.asFile((FileObject)this.prototype);
        ScriptUtil.Result result = scriptUtil.createExecution((String)this.classifier.orSome((Object)"default"), "pkg", this.getScripts(), workingDirectoryF, strategy).execute();
        LineStreamUtil.toFile((List)this.pkginfoFile.toList(), (File)pkginfoF);
        String pkg = this.pkginfoFile.getPkgName(pkginfoF);
        this.prototypeFile.addIFileIf(pkginfoF, "pkginfo");
        this.prototypeFile.addIFileIf(result.preInstall, "preinstall");
        this.prototypeFile.addIFileIf(result.postInstall, "postinstall");
        this.prototypeFile.addIFileIf(result.preRemove, "preremove");
        this.prototypeFile.addIFileIf(result.postRemove, "postremove");
        for (File file : result.customScripts) {
            this.prototypeFile.addIFileIf(file);
        }
        this.workingDirectory.resolveFile("assembly");
        for (Callable operation : this.operations) {
            operation.call();
        }
        LineStreamUtil.toFile((LineProducer)this.prototypeFile, (File)prototypeF);
        new PkgmkCommand().setDebug(this.debug).setOverwrite(true).setDevice(workingDirectoryF).setPrototype(prototypeF).execute();
        new PkgtransCommand().setDebug(this.debug).setAsDatastream(true).setOverwrite(true).execute(workingDirectoryF, packageFile, pkg);
    }

    public static String getPkgVersion(PackageVersion v) {
        String version = v.version;
        if (v.revision.isSome()) {
            version = version + "-" + (String)v.revision.some();
        }
        if (v.snapshot) {
            version = version + "-" + v.timestamp;
        }
        return version;
    }

    public FileObject getRoot() {
        return this.workingDirectory;
    }

    public FileCollector addDirectory(UnixFsObject.Directory directory) throws IOException {
        this.prototypeFile.addDirectory(directory);
        return this;
    }

    public FileCollector addFile(FileObject fromFile, UnixFsObject.RegularFile file) throws IOException {
        this.prototypeFile.addFile(this.fromFile(fromFile, file), file);
        return this;
    }

    public FileCollector addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.prototypeFile.addSymlink(symlink);
        return this;
    }

    public void apply(F2<UnixFsObject, FileAttributes, FileAttributes> f) {
        this.prototypeFile.apply(f);
    }

    public static PkgUnixPackage cast(UnixPackage unixPackage) {
        return (PkgUnixPackage)((Object)PkgUnixPackage.class.cast(unixPackage));
    }

    public FileObject fromFile(final FileObject fromFile, UnixFsObject.RegularFile file) throws FileSystemException {
        if (fromFile.getFileSystem() instanceof LocalFileSystem) {
            return fromFile;
        }
        final FileObject tmpFile = this.workingDirectory.resolveFile(file.path.string);
        this.operations = this.operations.cons((Object)new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                OutputStream outputStream = null;
                try {
                    tmpFile.getParent().createFolder();
                    tmpFile.copyFrom(fromFile, Selectors.SELECT_ALL);
                    tmpFile.getContent().setLastModifiedTime(fromFile.getContent().getLastModifiedTime());
                }
                finally {
                    IOUtil.close(outputStream);
                }
                return Unit.unit();
            }
        });
        return tmpFile;
    }
}

