/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sablecc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.sablecc.sablecc.SableCC;

public class SableCCMojo
extends AbstractMojo {
    private String sourceDirectory;
    private String outputDirectory;
    private String timestampDirectory;
    private int staleMillis;
    private MavenProjectHelper projectHelper;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Set staleGrammars;
        if (!FileUtils.fileExists((String)this.outputDirectory)) {
            FileUtils.mkdir((String)this.outputDirectory);
        }
        if ((staleGrammars = this.computeStaleGrammars()).isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process - all grammars are up to date");
            this.projectHelper.addResource(this.project, this.outputDirectory, Collections.singletonList("**/**.dat"), new ArrayList());
            this.project.addCompileSourceRoot(this.outputDirectory);
            return;
        }
        Iterator i = staleGrammars.iterator();
        while (i.hasNext()) {
            File grammar = (File)i.next();
            try {
                SableCC.processGrammar((File)grammar, (File)new File(this.outputDirectory));
                FileUtils.copyFileToDirectory((File)grammar, (File)new File(this.timestampDirectory));
            }
            catch (Exception e) {
                throw new MojoExecutionException("SableCC execution failed", e);
            }
            catch (Throwable t) {
                throw new MojoExecutionException("SableCC execution failed", t);
            }
        }
        if (this.project != null) {
            this.getLog().debug((CharSequence)"adding .dat resource");
            this.projectHelper.addResource(this.project, this.outputDirectory, Collections.singletonList("**/**.dat"), new ArrayList());
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }

    private Set computeStaleGrammars() throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping(".grammar", ".grammar");
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis);
        scanner.addSourceMapping((SourceMapping)mapping);
        File outDir = new File(this.timestampDirectory);
        HashSet staleSources = new HashSet();
        File sourceDir = new File(this.sourceDirectory);
        try {
            staleSources.addAll(scanner.getIncludedSources(sourceDir, outDir));
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' for stale grammars to reprocess.", (Exception)((Object)e));
        }
        return staleSources;
    }
}

