/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.mojo.rmic.AbstractRmiMojo;
import org.codehaus.mojo.rmic.RmicConfig;

public class Source
implements RmicConfig {
    private static final String INCLUDE_ALL = "**/*";
    private AbstractRmiMojo mojo;
    protected Set includes;
    protected Set excludes;
    private String version;
    private Boolean iiop;
    private Boolean noLocalStubs;
    private Boolean idl;
    private Boolean noValueMethods;
    private Boolean keep;
    private Boolean nowarn;
    private Boolean poa;
    private Boolean verbose;

    public boolean isIiop() {
        return Source.isSetOrDefault(this.iiop, this.mojo != null && this.mojo.isIiop());
    }

    public boolean isNoLocalStubs() {
        return Source.isSetOrDefault(this.noLocalStubs, this.mojo != null && this.mojo.isNoLocalStubs());
    }

    public boolean isIdl() {
        return Source.isSetOrDefault(this.idl, this.mojo != null && this.mojo.isIdl());
    }

    public boolean isNoValueMethods() {
        return Source.isSetOrDefault(this.noValueMethods, this.mojo != null && this.mojo.isNoValueMethods());
    }

    public boolean isKeep() {
        return Source.isSetOrDefault(this.keep, this.mojo != null && this.mojo.isKeep());
    }

    public boolean isNowarn() {
        return Source.isSetOrDefault(this.nowarn, this.mojo != null && this.mojo.isNowarn());
    }

    public boolean isPoa() {
        return Source.isSetOrDefault(this.poa, this.mojo != null && this.mojo.isPoa());
    }

    public boolean isVerbose() {
        return Source.isSetOrDefault(this.verbose, this.mojo != null && this.mojo.isVerbose());
    }

    public String getVersion() {
        return this.version != null ? this.version : (this.mojo == null ? null : this.mojo.getVersion());
    }

    private static boolean isSetOrDefault(Boolean field, boolean defaultValue) {
        return field != null ? field : defaultValue;
    }

    void setRmiMojo(AbstractRmiMojo mojo) {
        this.mojo = mojo;
    }

    Set getIncludes() {
        return !Source.isEmpty(this.includes) ? this.includes : (this.mojo == null || Source.isEmpty(this.mojo.includes) ? Source.createOneElementSet(INCLUDE_ALL) : this.mojo.includes);
    }

    Set getExcludes() {
        return !Source.isEmpty(this.excludes) ? this.excludes : (this.mojo == null || Source.isEmpty(this.mojo.excludes) ? new HashSet() : this.mojo.excludes);
    }

    private static HashSet createOneElementSet(Object element) {
        return new HashSet<Object>(Arrays.asList(element));
    }

    private static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Including ").append(this.getIncludes()).append("; excluding ").append(this.getExcludes());
        sb.append("\nwith options: ");
        this.appendIfTrue(sb, this.isIiop(), "-iiop");
        this.appendIfTrue(sb, this.isIiop() && this.isNoLocalStubs(), "-noLocalStubs");
        this.appendIfTrue(sb, this.isIdl(), "-idl");
        this.appendIfTrue(sb, this.isIdl() && this.isNoValueMethods(), "-noValueMethods");
        this.appendIfTrue(sb, this.isKeep(), "-keep");
        this.appendIfTrue(sb, this.isNowarn(), "-nowarn");
        this.appendIfTrue(sb, this.isPoa(), "-poa");
        if (this.getVersion() != null) {
            sb.append("-v").append(this.getVersion());
        }
        return sb.toString();
    }

    private void appendIfTrue(StringBuffer sb, boolean condition, String option) {
        if (condition) {
            sb.append(option).append(' ');
        }
    }
}

