/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.remotesrc;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.remotesrc.AbstractRemoteSourceMojo;
import org.codehaus.plexus.util.FileUtils;

public class SourceRelocateMojo
extends AbstractRemoteSourceMojo {
    private boolean skipRelocate;
    private String relativeSourceBase;
    private File expandTarget;
    private File relocateTarget;

    public void doExecute() throws MojoExecutionException {
        File expandedSourceDir = this.expandTarget;
        if (this.relativeSourceBase != null) {
            expandedSourceDir = new File(this.expandTarget, this.relativeSourceBase);
        }
        if (!expandedSourceDir.exists()) {
            throw new MojoExecutionException("Cannot find relative source directory: " + this.relativeSourceBase + " within unpacked source.");
        }
        try {
            FileUtils.copyDirectoryStructure((File)expandedSourceDir, (File)this.relocateTarget);
            FileUtils.deleteDirectory((File)expandedSourceDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy relative source directory: " + this.relativeSourceBase + " to basedir", (Exception)e);
        }
    }

    protected CharSequence getSkipMessage() {
        return "Skipping relocate step (per configuration).";
    }

    protected boolean isSkip() {
        return this.skipRelocate;
    }
}

