/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.remotesrc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.remotesrc.AbstractRemoteSourceMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class GetSourceArtifactMojo
extends AbstractRemoteSourceMojo {
    private boolean skipGet;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;
    private ArtifactResolver resolver;
    private ArtifactFactory factory;
    private List remoteRepositories;
    private ArtifactRepository localRepository;
    private File copyTo;

    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Resolving source archive for project: " + this.getProjectId() + " from: {repository}."));
        if (StringUtils.isEmpty((String)this.classifier) || StringUtils.isEmpty((String)this.type)) {
            throw new MojoExecutionException("You must specify both 'classifier' and 'type' parameters.\nSource artifact resolution cannot proceed.");
        }
        Artifact artifact = this.factory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.type, this.classifier);
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            this.setSourceArchiveFile(this.getProjectId(), artifact.getFile());
        }
        catch (ArtifactResolutionException e) {
            this.getLog().info((CharSequence)("Failed to resolve source artifact for: " + this.getProjectId()));
            this.getLog().debug((CharSequence)("Error resolving artifact: " + artifact.getId() + ". Reason: " + e.getMessage()), (Throwable)e);
            artifact = null;
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().info((CharSequence)("Failed to resolve source artifact for: " + this.getProjectId()));
            this.getLog().debug((CharSequence)("Cannot resolve source artifact: " + artifact.getId()), (Throwable)e);
            artifact = null;
        }
        if (this.getSourceArchiveFile(this.getProjectId()) == null) {
            throw new MojoFailureException((Object)this, "Failed to retrieve project source archive.", "Failed to retrieve project source archive. Use debug mode (-X) to see stack traces.");
        }
        if (this.copyTo != null) {
            try {
                this.copyTo = this.copyTo.getCanonicalFile();
                this.getLog().debug((CharSequence)("Copying downloaded source archive to: " + this.copyTo));
                this.copyTo.getParentFile().mkdirs();
                FileUtils.copyFile((File)this.getSourceArchiveFile(this.getProjectId()), (File)this.copyTo);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy source archive artifact to: " + this.copyTo + ". Reason: " + e.getMessage(), (Exception)e);
            }
        }
    }

    protected boolean isSkip() {
        return this.skipGet;
    }

    protected CharSequence getSkipMessage() {
        return "Skipping remote source retrieval (per configuration).";
    }
}

