/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.codehaus.mojo.license.utils.FileUtil;

public class LicenseDownloader {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadLicense(String licenseUrlString, String loginPassword, File outputFile) throws IOException {
        if (licenseUrlString == null || licenseUrlString.length() == 0) {
            return;
        }
        InputStream licenseInputStream = null;
        FileOutputStream fos = null;
        try {
            URLConnection connection = LicenseDownloader.newConnection(licenseUrlString, loginPassword);
            boolean redirect = false;
            if (connection instanceof HttpURLConnection) {
                int status = ((HttpURLConnection)connection).getResponseCode();
                boolean bl = redirect = 302 == status || 301 == status || 303 == status;
            }
            if (redirect) {
                String newUrl = connection.getHeaderField("Location");
                connection = LicenseDownloader.newConnection(newUrl, loginPassword);
            }
            licenseInputStream = connection.getInputStream();
            fos = new FileOutputStream(LicenseDownloader.updateFileExtension(outputFile, connection.getContentType()));
            LicenseDownloader.copyStream(licenseInputStream, fos);
            licenseInputStream.close();
            fos.close();
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            FileUtil.tryClose(licenseInputStream);
            FileUtil.tryClose(fos);
            throw throwable;
        }
        FileUtil.tryClose(licenseInputStream);
        FileUtil.tryClose(fos);
    }

    private static void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, len);
        }
    }

    private static URLConnection newConnection(String url, String loginPassword) throws IOException {
        URL licenseUrl = new URL(url);
        URLConnection connection = licenseUrl.openConnection();
        if (loginPassword != null) {
            connection.setRequestProperty("Proxy-Authorization", loginPassword);
        }
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        return connection;
    }

    private static File updateFileExtension(File outputFile, String mimeType) {
        String realExtension = LicenseDownloader.getFileExtension(mimeType);
        if (realExtension != null && !outputFile.getName().endsWith(realExtension)) {
            return new File(outputFile.getAbsolutePath() + realExtension);
        }
        return outputFile;
    }

    private static String getFileExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        String lowerMimeType = mimeType.toLowerCase();
        if (lowerMimeType.contains("plain")) {
            return ".txt";
        }
        if (lowerMimeType.contains("html")) {
            return ".html";
        }
        if (lowerMimeType.contains("pdf")) {
            return ".pdf";
        }
        return null;
    }
}

