/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractPackagingMojo
extends AbstractMojo {
    private MavenProject project;
    private File outputDirectory;
    private File classesDirectory;
    private File packagingDirectory;
    private String deploymentDescriptorDestName;
    private File deploymentDescriptorDest;
    private File libDirectory;
    private String archiveName;
    private boolean excludeAll;
    private Set excludes;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File manifest;
    private String classifier;
    private boolean primaryArtifact;
    private MavenProjectHelper projectHelper;
    private ArtifactHandlerManager artifactHandlerManager;
    private boolean removeDependencyVersions;
    private boolean explodedOnly;

    public boolean isExplodedOnly() {
        return this.explodedOnly;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getPackagingDirectory() {
        return this.packagingDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public File getLibDirectory() {
        return this.libDirectory;
    }

    public abstract File getDeploymentDescriptor();

    public abstract String getArtifactType();

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void buildExplodedPackaging() throws MojoExecutionException {
        this.buildExplodedPackaging(Collections.EMPTY_SET);
    }

    public void buildExplodedPackaging(Set excludes) throws MojoExecutionException {
        String[] files;
        File deploymentDescriptorTarget;
        File deploymentDescriptorFile;
        this.getLog().info((CharSequence)("Assembling JBoss packaging " + this.project.getArtifactId() + " in " + this.packagingDirectory));
        if (excludes == null) {
            excludes = Collections.EMPTY_SET;
        }
        this.packagingDirectory.mkdirs();
        this.libDirectory.mkdirs();
        try {
            this.packageResources();
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Failed while packaging resources", e1);
        }
        if (this.classesDirectory.exists() && !this.classesDirectory.equals(this.packagingDirectory)) {
            try {
                this.packageClasses();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to copy classes directory", e);
            }
        }
        if ((deploymentDescriptorFile = this.getDeploymentDescriptor()) == null || !deploymentDescriptorFile.exists()) {
            throw new MojoExecutionException("Could not find descriptor file: " + deploymentDescriptorFile);
        }
        String destName = this.getDeploymentDescriptorDestName();
        if (destName == null) {
            destName = deploymentDescriptorFile.getName();
        }
        if (!(deploymentDescriptorTarget = new File(this.getDeploymentDescriptorDest(), destName)).exists()) {
            deploymentDescriptorTarget.getParentFile().mkdirs();
            try {
                FileUtils.copyFile((File)deploymentDescriptorFile, (File)deploymentDescriptorTarget);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy deployment descriptor", (Exception)e);
            }
        }
        Set artifacts = this.project.getArtifacts();
        ArrayList<Artifact> rejects = new ArrayList<Artifact>();
        HashSet<String> includedArtifacts = new HashSet<String>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        this.getLog().debug((CharSequence)"");
        this.getLog().debug((CharSequence)"    Including artifacts: ");
        this.getLog().debug((CharSequence)"    -------------------");
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            String descriptor = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (!this.excludeAll && artifact.getArtifactHandler().isAddedToClasspath() && !excludes.contains(descriptor)) {
                this.getLog().debug((CharSequence)("        o " + descriptor));
                String name = this.getArtifactName(artifact);
                if (!includedArtifacts.add(name)) {
                    name = artifact.getGroupId() + "-" + name;
                    this.getLog().info((CharSequence)("Duplicate artifact discovered, using full name: " + name));
                }
                try {
                    this.packageLib(artifact, name);
                    continue;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Could not copy dependency", e);
                }
            }
            rejects.add(artifact);
        }
        if (!excludes.isEmpty()) {
            this.getLog().debug((CharSequence)"");
            this.getLog().debug((CharSequence)"    Excluded artifacts: ");
            this.getLog().debug((CharSequence)"    ------------------");
            for (int ii = 0; ii < rejects.size(); ++ii) {
                this.getLog().debug((CharSequence)("        o " + rejects.get(ii)));
            }
        } else {
            this.getLog().debug((CharSequence)"No artifacts have been excluded.");
        }
        this.getLog().debug((CharSequence)"");
        this.buildSpecificPackaging(excludes);
        if (this.libDirectory.isDirectory() && (files = this.libDirectory.list()).length == 0) {
            this.libDirectory.delete();
        }
    }

    protected void buildSpecificPackaging(Set excludes) throws MojoExecutionException {
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    protected void performPackaging() throws MojoExecutionException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(this.getArtifactType());
        String extension = artifactHandler.getExtension();
        String type = this.getArtifactType();
        File archiveFile = AbstractPackagingMojo.calculateFile(this.outputDirectory, this.archiveName, this.classifier, extension);
        this.getLog().debug((CharSequence)("Generating JBoss packaging " + archiveFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        try {
            this.jarArchiver.addDirectory(this.getPackagingDirectory());
            if (this.manifest != null) {
                this.jarArchiver.setManifest(this.manifest);
            }
            archiver.createArchive(this.getProject(), this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem generating archive file.", e);
        }
        if (this.classifier != null && !this.classifier.equals("")) {
            this.primaryArtifact = false;
        }
        if (this.primaryArtifact) {
            Artifact artifact = this.project.getArtifact();
            artifact.setFile(archiveFile);
            artifact.setArtifactHandler(artifactHandler);
        } else {
            this.projectHelper.attachArtifact(this.project, type, this.classifier, archiveFile);
        }
    }

    private static File calculateFile(File outputDirectory, String archiveName, String classifier, String extension) {
        String basename = StringUtils.isEmpty((String)classifier) ? archiveName : archiveName + '-' + classifier;
        return new File(outputDirectory, basename + '.' + extension);
    }

    private String getArtifactName(Artifact artifact) {
        String artifactName = artifact.getArtifactId();
        if (!this.removeDependencyVersions) {
            artifactName = artifactName + "-" + artifact.getVersion();
        }
        if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
            artifactName = artifactName + "-" + artifact.getClassifier();
        }
        artifactName = artifactName + "." + artifact.getArtifactHandler().getExtension();
        return artifactName;
    }

    public String getDeploymentDescriptorDestName() {
        return this.deploymentDescriptorDestName;
    }

    public File getDeploymentDescriptorDest() {
        return this.deploymentDescriptorDest;
    }

    public void execute() throws MojoExecutionException {
        this.buildExplodedPackaging(this.excludes);
        if (!this.isExplodedOnly()) {
            this.performPackaging();
        }
    }

    protected void packageResources() throws Exception {
    }

    protected void packageLib(Artifact artifact, String name) throws Exception {
        FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libDirectory, name));
    }

    protected void packageClasses() throws Exception {
        FileUtils.copyDirectoryStructure((File)this.classesDirectory, (File)this.packagingDirectory);
    }
}

