/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jalopy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class Locator {
    private Log log;
    private File localDir;

    public Locator(Log log, File resolveToDir) {
        this.log = log;
        this.localDir = resolveToDir;
    }

    private Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public File resolveLocation(String location, String localfile) throws IOException {
        this.getLog().debug((CharSequence)("resolveLocation(" + location + ", " + localfile + ")"));
        if (StringUtils.isEmpty((String)location)) {
            return null;
        }
        File retFile = new File(this.localDir, localfile);
        if (location.indexOf("://") > 1) {
            URL url = new URL(location);
            this.getLog().debug((CharSequence)("Potential URL: " + url.toExternalForm()));
            FileUtils.copyURLToFile((URL)url, (File)retFile);
        } else {
            this.getLog().debug((CharSequence)"Location is not a URL.");
            File fileLocation = new File(location);
            if (fileLocation.exists()) {
                this.getLog().debug((CharSequence)("Potential File: " + fileLocation.getAbsolutePath()));
                FileUtils.copyFile((File)fileLocation, (File)retFile);
            } else {
                this.getLog().debug((CharSequence)"Location is not a File.");
                URL url = this.getClass().getClassLoader().getResource(location);
                if (url != null) {
                    this.getLog().debug((CharSequence)("Potential Resource: " + url.toExternalForm()));
                    FileUtils.copyURLToFile((URL)url, (File)retFile);
                } else {
                    this.getLog().debug((CharSequence)"Location is not a Resource.");
                    throw new IOException("Unable to find location '" + location + "' as URL, File or Resource. Working dir is " + new File("").getAbsolutePath());
                }
            }
        }
        if (!retFile.exists()) {
            throw new FileNotFoundException("Destination file does not exist.");
        }
        if (retFile.length() <= 0L) {
            throw new IOException("Destination file has no content: " + retFile + ". Is " + location + " empty?");
        }
        return retFile;
    }
}

