/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.codehaus.mojo.fitnesse.log.FitnesseStreamConsumer;

public class FileConsumer
implements FitnesseStreamConsumer {
    FileWriter mOutputWriter;
    private boolean mHasGeneratedResultFile = false;
    private String mLineSep = System.getProperty("line.separator");

    public FileConsumer() {
    }

    public FileConsumer(File pOutputFile) {
        try {
            this.mOutputWriter = new FileWriter(pOutputFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write into file");
        }
    }

    public synchronized void consumeLine(String pMessage) {
        try {
            this.mOutputWriter.write(pMessage + this.mLineSep);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write into file");
        }
        this.mHasGeneratedResultFile = this.mHasGeneratedResultFile || pMessage.startsWith("Formatting as html");
    }

    public boolean hasGeneratedResultFile() {
        return this.mHasGeneratedResultFile;
    }

    public void close() {
        try {
            this.mOutputWriter.flush();
            this.mOutputWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write into file");
        }
    }
}

