/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.common.ProjectBaseDir;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.jmeter.GCLogParser;
import org.codehaus.mojo.chronos.jmeter.JMeterLogParser;
import org.jdom.Element;

public class JMeterOutputMojo
extends AbstractMojo {
    public MavenProject project;
    private File jmeterOutput;
    private String dataid;
    private File gclogfile;

    public void execute() throws MojoExecutionException {
        if (!this.jmeterOutput.exists()) {
            throw new MojoExecutionException("Invalid argument 'input', " + this.jmeterOutput.getPath() + " does not exist.");
        }
        TestDataDirectory testDataDirectory = new ProjectBaseDir(this.project, this.getLog()).getDataDirectory(this.dataid);
        if (this.jmeterOutput.isDirectory()) {
            File[] inputFiles;
            for (File outputJtlFile : inputFiles = IOUtil.listFilesWithExtension((File)this.jmeterOutput, (String)"jtl")) {
                JMeterOutputMojo.parseJMeterOutput(testDataDirectory, outputJtlFile);
            }
        } else if (this.isJtlFile(this.jmeterOutput)) {
            JMeterOutputMojo.parseJMeterOutput(testDataDirectory, this.jmeterOutput);
        } else {
            throw new MojoExecutionException("Executing jmeter tests is not supported. We suggest using the jmeter-maven-plugin ");
        }
        JMeterOutputMojo.parseGCLog(testDataDirectory, this.getGcLogFile());
    }

    public static void parseGCLog(TestDataDirectory testDataDirectory, File gcLogFile) throws MojoExecutionException {
        if (gcLogFile != null && gcLogFile.exists()) {
            try {
                Element gcSamplesXml = new GCLogParser().convertToChronosFormat(gcLogFile);
                testDataDirectory.writeGCLog(gcSamplesXml);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to parseJtl20 garbage collection log", (Exception)e);
            }
        }
    }

    public static void parseJMeterOutput(TestDataDirectory testDataDirectory, File jtlFile) throws MojoExecutionException {
        try {
            Element samplesElement = new JMeterLogParser().convertToChronosXml(jtlFile);
            String jtlName = IOUtil.removeExtension((String)jtlFile.getName());
            testDataDirectory.writeResponsetimeSamples(jtlName, samplesElement);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not parseJtl20 jmeter log", e);
        }
    }

    private boolean isJtlFile(File input) {
        return input.getName().endsWith(".jtl");
    }

    private File getGcLogFile() {
        if (this.gclogfile != null) {
            return this.gclogfile;
        }
        File chronosDir = new ProjectBaseDir(this.getProject().getBasedir(), this.getLog()).getChronosDir();
        return new File(chronosDir, "gclog-" + this.dataid + ".txt");
    }

    protected final MavenProject getProject() {
        return this.project;
    }
}

