/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod.pom.rewrite;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DefaultMavenProjectBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.codehaus.mojo.resolver.bod.pom.rewrite.PomRewriteConfiguration;
import org.codehaus.mojo.resolver.bod.pom.rewrite.PomRewriter;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPomRewriter
implements PomRewriter,
Contextualizable {
    private MavenProjectBuilder projectBuilder;
    private PlexusContainer container;
    private MavenXpp3Reader modelReader = new MavenXpp3Reader();
    private MavenXpp3Writer modelWriter = new MavenXpp3Writer();

    public DefaultPomRewriter() {
    }

    public DefaultPomRewriter(MavenProjectBuilder projectBuilder, PlexusContainer container) {
        this.projectBuilder = projectBuilder;
        this.container = container;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeFromProjectBuilderCache(MavenProject project) throws ProjectBuildingException {
        if (this.projectBuilder instanceof DefaultMavenProjectBuilder) {
            try {
                Field[] fields = new Field[]{ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"rawProjectCache", this.projectBuilder.getClass()), ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"processedProjectCache", this.projectBuilder.getClass())};
                String cacheKey = project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion();
                for (int i = 0; i < fields.length; ++i) {
                    boolean accessible = fields[i].isAccessible();
                    try {
                        fields[i].setAccessible(true);
                        Map cache = (Map)fields[i].get(this.projectBuilder);
                        cache.remove(cacheKey);
                        continue;
                    }
                    finally {
                        fields[i].setAccessible(accessible);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new ProjectBuildingException(project.getId(), "Failed to purge project-builder cache, IllegalAccessException");
            }
            catch (SecurityException e) {
                throw new ProjectBuildingException(project.getId(), "Failed to purge project-builder cache, SecurityException");
            }
        }
    }

    @Override
    public List<MavenProject> rewrite(List<MavenProject> projectInstances, PomRewriteConfiguration configuration, ArtifactRepository localRepository, MessageHolder errors) {
        String includes = null;
        String excludes = null;
        if (configuration == null || configuration.isEmpty()) {
            StringBuffer incl = new StringBuffer();
            Iterator<MavenProject> it = projectInstances.iterator();
            while (it.hasNext()) {
                MavenProject project = it.next();
                incl.append(ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()));
                if (!it.hasNext()) continue;
                incl.append(',');
            }
            includes = incl.toString();
            excludes = "";
        } else {
            includes = configuration.getIncludesAsCSV();
            excludes = configuration.getExcludesAsCSV();
        }
        ArrayList<MavenProject> changedInstances = new ArrayList<MavenProject>(projectInstances.size());
        for (MavenProject project : projectInstances) {
            String versionlessKey = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            if (includes.indexOf(versionlessKey) > -1 || excludes.indexOf(versionlessKey) < 0) {
                MavenProject original = project;
                try {
                    project = this.rewriteProject(project, configuration, localRepository);
                    project.setFile(original.getFile());
                }
                catch (IOException e) {
                    errors.addMessage((CharSequence)("Failed to rewrite project: " + project.getId()), (Throwable)e);
                }
                catch (ProjectBuildingException e) {
                    errors.addMessage((CharSequence)("Failed to rewrite project: " + project.getId()), (Throwable)e);
                }
            }
            changedInstances.add(project);
        }
        return changedInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model rewriteModelTo(Model model, PomRewriteConfiguration configuration, File target) throws IOException {
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            DistributionManagement newDistMgmt = new DistributionManagement();
            newDistMgmt.setDownloadUrl(distMgmt.getDownloadUrl());
            newDistMgmt.setRelocation(distMgmt.getRelocation());
            newDistMgmt.setRepository(distMgmt.getRepository());
            newDistMgmt.setSite(distMgmt.getSite());
            newDistMgmt.setSnapshotRepository(distMgmt.getSnapshotRepository());
            model.setDistributionManagement(newDistMgmt);
        }
        if (configuration != null) {
            Properties injectorProperties = configuration.getProperties();
            Properties modelProperties = model.getProperties();
            modelProperties.putAll((Map<?, ?>)injectorProperties);
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(target);
            this.modelWriter.write((Writer)writer, model);
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void rewriteOnDisk(File pomFile, PomRewriteConfiguration configuration, MessageHolder errors) {
        FileReader reader = null;
        Model model = null;
        try {
            reader = new FileReader(pomFile);
            model = this.modelReader.read((Reader)reader);
        }
        catch (IOException e) {
            errors.addMessage((CharSequence)("Error reading POM from: " + pomFile), (Throwable)e);
            IOUtil.close((Reader)reader);
        }
        catch (XmlPullParserException e2) {
            errors.addMessage((CharSequence)("Error reading POM from: " + pomFile), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
        }
        IOUtil.close((Reader)reader);
        if (model != null) {
            try {
                if (configuration != null && configuration.getParentArtifactId() != null) {
                    model.getParent().setArtifactId(configuration.getParentArtifactId());
                }
                this.rewriteModelTo(model, configuration, pomFile);
            }
            catch (IOException e) {
                errors.addMessage((CharSequence)("Error writing POM to: " + pomFile), (Throwable)e);
            }
        }
    }

    private MavenProject rewriteProject(MavenProject project, PomRewriteConfiguration configuration, ArtifactRepository localRepository) throws IOException, ProjectBuildingException {
        this.purgeFromProjectBuilderCache(project);
        MavenProject rewritten = project;
        Model model = project.getOriginalModel();
        File tempPom = File.createTempFile(project.getArtifactId() + ".rewritten.", ".pom");
        tempPom.deleteOnExit();
        model = this.rewriteModelTo(model, configuration, tempPom);
        DefaultProfileManager profileMgr = new DefaultProfileManager(this.container);
        profileMgr.explicitlyActivate(project.getActiveProfiles());
        rewritten = this.projectBuilder.build(tempPom, localRepository, (ProfileManager)profileMgr);
        return rewritten;
    }
}

