/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenProjectUtils {
    private MavenProjectUtils() {
        throw new AssertionError();
    }

    public static List<String> getClasspathElements(MavenProject project, List<Artifact> artifacts) throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        for (Artifact artifact : artifacts) {
            if (!artifact.getArtifactHandler().isAddedToClasspath() || !"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
            MavenProjectUtils.addArtifactPath(project, artifact, list);
        }
        return list;
    }

    public static boolean containsDirectory(List<Resource> resources, String directory) {
        for (Resource resource : resources) {
            if (!directory.equals(resource.getDirectory())) continue;
            return true;
        }
        return false;
    }

    private static void addArtifactPath(MavenProject project, Artifact artifact, List<String> list) throws DependencyResolutionRequiredException {
        String refId = MavenProjectUtils.getProjectReferenceId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject refProject = (MavenProject)project.getProjectReferences().get(refId);
        boolean projectDirFound = false;
        if (refProject != null) {
            if (artifact.getType().equals("test-jar")) {
                File testOutputDir = new File(refProject.getBuild().getTestOutputDirectory());
                if (testOutputDir.exists()) {
                    list.add(testOutputDir.getAbsolutePath());
                    projectDirFound = true;
                }
            } else {
                list.add(refProject.getBuild().getOutputDirectory());
                projectDirFound = true;
            }
        }
        if (!projectDirFound) {
            File file = artifact.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(artifact);
            }
            list.add(file.getPath());
        }
    }

    private static String getProjectReferenceId(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }
}

