/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.atomic.AtomicInteger;

final class RunState
extends AtomicInteger {
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOPPING = 2;
    static final int TERMINATED = 4;

    RunState() {
    }

    boolean isRunning() {
        return this.get() == 0;
    }

    boolean isShutdown() {
        return this.get() == 1;
    }

    boolean isStopping() {
        return this.get() == 2;
    }

    boolean isTerminated() {
        return this.get() == 4;
    }

    boolean isAtLeastShutdown() {
        return this.get() >= 1;
    }

    boolean isAtLeastStopping() {
        return this.get() >= 2;
    }

    boolean transitionToShutdown() {
        return this.transitionTo(1);
    }

    boolean transitionToStopping() {
        return this.transitionTo(2);
    }

    boolean transitionToTerminated() {
        return this.transitionTo(4);
    }

    boolean transitionTo(int state) {
        int s;
        do {
            if ((s = this.get()) < state) continue;
            return false;
        } while (!this.compareAndSet(s, state));
        return true;
    }
}

