/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.email.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.beans.SendingHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.EmailHandler;
import org.chorem.vradi.ui.email.helpers.EmailDataHelper;
import org.chorem.vradi.ui.email.loadors.AbstractEmailNodeLoador;
import org.chorem.vradi.ui.email.loadors.EmailFormNodeLoadors;
import org.chorem.vradi.ui.email.loadors.EmailGroupNodeLoadors;
import org.chorem.vradi.ui.email.loadors.EmailGroupUsersNodeLoadors;
import org.chorem.vradi.ui.email.loadors.EmailUsersNodeLoadors;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.chorem.vradi.ui.tree.helpers.VradiTreeHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.WikittyProxy;

public class EmailNavigationTreeHelper
extends VradiTreeHelper<Session> {
    private static final Log log = LogFactory.getLog(EmailNavigationTreeHelper.class);
    protected List<Session> sessions;
    protected Date searchDate;
    public static String PATH_SEPARATOR = "/";
    protected EmailFilterEnum filter = EmailFilterEnum.FILTER_BY_USER;
    protected VradiEntitiesListener<Sending> sendingVradiEntitiesListener;

    public EmailNavigationTreeHelper(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(Session.class, this);
        this.sendingVradiEntitiesListener = new VradiEntitiesListener<Sending>(){

            @Override
            public void entitiesAdded(Set<Sending> added) {
                for (Sending sending : added) {
                    EmailNavigationTreeHelper.this.updateSendingInTree(sending);
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
                EmailNavigationTreeHelper.this.removeEntities(removed);
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(Sending.class, this.sendingVradiEntitiesListener);
    }

    @Override
    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public WikittyProxy getProxy() {
        return this.getDataProvider().getWikittyProxy();
    }

    protected EmailHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, EmailHandler.class);
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public boolean isByForm() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_FORM);
    }

    public boolean isByUser() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_USER);
    }

    public boolean isByGroup() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_GROUP);
    }

    public Session getSelectedActiveSession() {
        Session session;
        Session activeSession = null;
        VradiTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && VradiConstants.SessionStatus.isToSend((Session)(session = EmailNavigationTreeHelper.getParentSession(selectedNode)))) {
            activeSession = session;
        }
        return activeSession;
    }

    public void updateTree(List<Session> sessions, EmailFilterEnum filter, Date searchDate) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("update data, nb sessions : " + sessions.size()));
        }
        this.filter = filter;
        this.sessions = sessions;
        this.searchDate = searchDate;
        VradiTreeNode rootNode = new VradiTreeNode(String.class, "Root node", null, null);
        for (Session session : sessions) {
            rootNode.add(this.createSessionNode(session));
        }
        DefaultTreeModel model = this.createModel(rootNode, new Object[0]);
        ((NavTreeBridge)this.getBridge()).setRoot((NavTreeNode)rootNode);
        rootNode.populateChilds(this.getBridge(), this.getDataProvider());
        ((JTree)this.getUI()).setModel(model);
    }

    public VradiTreeNode createSessionNode(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createSession node " + session.getSessionDate() + " num " + session.getNum()));
        }
        String sessionId = session.getWikittyId();
        AbstractEmailNodeLoador nodeLoador = null;
        if (this.isByForm()) {
            nodeLoador = new EmailFormNodeLoadors();
        } else if (this.isByUser()) {
            nodeLoador = new EmailUsersNodeLoadors();
        } else if (this.isByGroup()) {
            nodeLoador = new EmailGroupNodeLoadors();
        }
        return new VradiTreeNode(Session.class, sessionId, null, nodeLoador);
    }

    public Session getSessionSelected() {
        return this.getSessionToDisplay(this.getSelectedNode());
    }

    public Session getSessionToDisplay(VradiTreeNode node) {
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        return session;
    }

    public Sending getSendingToDisplay(VradiTreeNode node) {
        String id = node.getId();
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        return EmailDataHelper.getUserSending(session, id);
    }

    public List<Sending> getSendingListToDisplay(VradiTreeNode node) {
        HashMap<String, Sending> result = new HashMap<String, Sending>();
        Class type = node.getInternalClass();
        String id = node.getId();
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        if (type.equals(Form.class)) {
            List<Sending> sendings = this.getSendingByForm(session, id);
            this.addSendingToMap(result, sendings);
        }
        return new ArrayList<Sending>(result.values());
    }

    protected void addSendingToMap(Map<String, Sending> result, List<Sending> sendings) {
        for (Sending sending : sendings) {
            result.put(sending.getWikittyId(), sending);
        }
    }

    protected List<Sending> getSendingByForm(Session session, String formId) {
        Set sendingIdsSet = session.getSending();
        ArrayList<Sending> result = new ArrayList<Sending>();
        if (sendingIdsSet == null) {
            return result;
        }
        List sendings = this.getProxy().restore(Sending.class, new ArrayList(sendingIdsSet));
        for (Sending sending : sendings) {
            if (sending == null) continue;
            Set formIdsSet = SendingHelper.extractForms((WikittyProxy)VradiService.getWikittyProxy(), (Collection)sending.getGroupForms());
            if (formIdsSet == null) {
                return result;
            }
            if (!formIdsSet.contains(formId)) continue;
            result.add(sending);
        }
        return result;
    }

    protected List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }

    public static Session getParentSession(VradiTreeNode node) {
        VradiTreeNode sessionNode = EmailNavigationTreeHelper.getParentSessionNode(node);
        if (sessionNode == null) {
            return null;
        }
        return (Session)VradiService.getWikittyProxy().restore(Session.class, sessionNode.getId());
    }

    public static VradiTreeNode getParentSessionNode(VradiTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getInternalClass().equals(Session.class)) {
            return node;
        }
        VradiTreeNode parent = (VradiTreeNode)node.getParent();
        return EmailNavigationTreeHelper.getParentSessionNode(parent);
    }

    @Override
    public void createEntityNode(String wikittyId) {
    }

    @Override
    public void entitiesAdded(Set<Session> added) {
        for (Session session : added) {
            String wikittyId = session.getWikittyId();
            VradiTreeNode existingNode = this.findNode(this.getRootNode(), wikittyId);
            if (existingNode != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[Session] Modification case :  " + existingNode.getId()));
                }
                this.refresh(existingNode);
                continue;
            }
            if (0 != DateUtil.getDifferenceInDays((Date)this.searchDate, (Date)session.getSessionDate())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Session] Creation case :  " + session.getSessionDate()));
            }
            VradiTreeNode newSessionNode = this.createSessionNode(session);
            this.insertNode((NavNode)this.getRootNode(), (NavNode)newSessionNode);
            this.refresh(newSessionNode);
        }
    }

    protected void updateSendingInTree(Sending sending) {
        block22: {
            VradiTreeNode sessionNode;
            block21: {
                if (sending == null) {
                    return;
                }
                Session session = null;
                String wikittyId = sending.getWikittyId();
                try {
                    session = VradiService.getVradiDataService().getSessionOfSending(wikittyId);
                }
                catch (VradiException eee) {
                    log.error((Object)("Can't find session for sending '" + wikittyId + "'"), (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                if (session == null) {
                    return;
                }
                sessionNode = this.findNode(this.getRootNode(), session.getWikittyId());
                if (sessionNode == null) {
                    return;
                }
                if (!this.isByForm()) break block21;
                Set formsIds = SendingHelper.extractForms((WikittyProxy)VradiService.getWikittyProxy(), (Collection)sending.getGroupForms());
                if (formsIds == null) break block22;
                for (String formId : formsIds) {
                    VradiTreeNode formNode = this.findNode(sessionNode, formId);
                    if (formNode != null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] add form " + formId));
                    }
                    this.createNode(sessionNode, Form.class, formId, null);
                }
                break block22;
            }
            if (this.isByUser()) {
                String userId = sending.getUser();
                VradiTreeNode userNode = this.findNode(sessionNode, userId);
                if (userNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] refresh user " + userId));
                    }
                    this.refresh(userNode);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] create user " + userId));
                    }
                    this.createNode(sessionNode, User.class, userId, null);
                }
            } else if (this.isByGroup()) {
                String userId = sending.getUser();
                VradiTreeNode userNode = this.findNode(sessionNode, userId);
                if (userNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Sending] refresh user " + userId));
                    }
                    this.refresh(userNode);
                } else {
                    List groupList = VradiService.getVradiDataService().findUserGroups(userId);
                    for (Group group : groupList) {
                        String groupId = group.getWikittyId();
                        VradiTreeNode groupNode = this.findNode(sessionNode, groupId);
                        if (groupNode != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("[Sending] create user " + userId));
                            }
                            this.createNode(sessionNode, User.class, userId, null);
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("[Sending] create group " + userId));
                        }
                        this.createNode(sessionNode, Group.class, groupId, EmailGroupUsersNodeLoadors.class);
                    }
                }
            }
        }
    }

    protected void createNode(VradiTreeNode sessionNode, Class typeNode, String id, Class<? extends AbstractEmailNodeLoador<?>> loadorClass) {
        AbstractEmailNodeLoador nodeLoador = null;
        if (loadorClass != null) {
            nodeLoador = (AbstractEmailNodeLoador)NavHelper.getChildLoador(loadorClass);
        }
        VradiTreeNode newNode = new VradiTreeNode(typeNode, id, null, nodeLoador);
        sessionNode.add(newNode);
        ((NavTreeBridge)this.getBridge()).notifyNodeInserted((NavTreeNode)newNode);
    }

    public static enum EmailFilterEnum {
        FILTER_BY_USER(I18n._((String)"vradi.email.userFilter", (Object[])new Object[0])),
        FILTER_BY_GROUP(I18n._((String)"vradi.email.groupFilter", (Object[])new Object[0])),
        FILTER_BY_FORM(I18n._((String)"vradi.email.formFilter", (Object[])new Object[0]));

        protected int value;
        protected String text;

        private EmailFilterEnum(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

