/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ThesaurusTreeTableNodeLoadors.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/thesaurus/loadors/ThesaurusTreeTableNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.thesaurus.loadors;

import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.thesaurus.ThesaurusDataProvider;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.tree.VradiTreeTableNode;
import org.nuiton.wikitty.entities.BusinessEntity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/** @author letellier */
public class ThesaurusTreeTableNodeLoadors extends NavTreeTableNodeChildLoador<String, Thesaurus, VradiTreeTableNode> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** Logger */
    static private final Log log =
            LogFactory.getLog(ThesaurusTreeTableNodeLoadors.class);

    public ThesaurusTreeTableNodeLoadors() {
        super(Thesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // ne recupere pas seulement les id pour les mettre en cache
        Collection<Thesaurus> thesauruses = ((ThesaurusDataProvider) dataProvider).getChildrenThesaurus(parentId);

        if (log.isDebugEnabled()) {
            if (RootThesaurus.class.equals(parentClass)) {
                RootThesaurus root = ThesaurusDataHelper.restoreRootThesaurus(parentId);
                for (Thesaurus thesaurus : thesauruses) {
                    log.debug("Children of root thesaurus " + root.getName() + " find : " + thesaurus.getName());
                }
            } else {
                Thesaurus root = ThesaurusDataHelper.restoreThesaurus(parentId);
                for (Thesaurus thesaurus : thesauruses) {
                    log.debug("Children of root thesaurus " + root.getName() + " find : " + thesaurus.getName());
                }
            }
        }

        return extractIds(thesauruses);
    }

    @Override
    public VradiTreeTableNode createNode(String id, NavDataProvider dataProvider) {

        return new VradiTreeTableNode(
                getBeanType(),
                id,
                null,
                NavHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)
        );
    }

    protected List<String> extractIds(Collection<? extends BusinessEntity> entities) {
        List<String> ids = new ArrayList<String>();
        for (BusinessEntity e : entities) {
            ids.add(e.getWikittyId());
        }
        return ids;
    }
}
