/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.search;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.renderers.NumberListCellRenderer;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class PaginationUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FORM_NB_LABEL_TEXT = "formNbLabel.text";
    public static final String BINDING_NEXT_PAGE_VISIBLE = "nextPage.visible";
    public static final String BINDING_PAGE_NUMBER_TEXT = "pageNumber.text";
    public static final String BINDING_PAGE_WANTED_TEXT = "pageWanted.text";
    public static final String BINDING_PREVIOUS_PAGE_VISIBLE = "previousPage.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVwW7TQBDdBJImLYWmgVKg0AKVEBenBQRCLQVSFEoV2oqCQOTCOt4mW9m7ZncdXA6IT+AT4M4FiRsnxIEzBy6IX0CIA1fErJM4GNzUojms4515b97M7oxff0MZKdDJTez7hvCYog4xlq8/eLBqbpK6ukFkXVBXcYHav1QapWtoyAr3pUKna1UNL3XgpUXuuJwR9gd6rooGpdqyiWwSohQ6HkXUpSyth+Y53/VElzUUFcf68sf39Avr+as0Qr4L6oYhlamdUL1M9lZRmloKjUKkFi7ZmDVAhqCsAXqH9d6ijaVcwQ55jJ6hgSrKulgAmUKnkqcccAR431UoN728hhmxZxQ6w0XDqDe5II7REtiihkcNSbCoN4013KAMK8rZvVuuG8CzChX5xgYRVSrVXWza5Da3iK3QhTiewNNwtIc0Vv+F9Uiz00tl7oOew5HKySdQB0ObtF8+dB/a4MJZMavY1LFHdZX8jvNysKn9DoTukG+wO6PfD0Zt7ciz+q0QDdJFzYaow70iaAGyvAUlIlB3kwOHQociQrr7UWQ73rmYePtcQVqUe1KTQogIWdlTijPteSIEDLrgeB8zReD+TEbcKyAPKzDcJb6qUGJbMdAVzzGJCLPrWXMMUFqFfj/VsQl0LHI20C9Gr196FzpVQxnhwbZC47V/W+wOmNrNNf5Xc2nCwPprrPj53de3lW5HFSD2oVjXPwYC3HRXcJcIRXXoA+128hS1S7exO1dDeUlsmCbBtJiIEbbeMYM4iFfQcEPDjSUsm0CRGfjy/sPYo097ULqCBm2OrQrW/rdQXjUFVIHblu9evRYo2vckB+uI1gZHbuMtDueH9s9bWOEpkzILTmnBhyJMxBQhVGLmP/4srr+51i1ECoQd2da9V4zMQ5SlzKaMBMOlMzdih8mQK4ln8d58iJsYKf0cdDvtWgrW83GZFlq6/nVsX7dpgzkwi7TrRd/Tj0tBBvrf5YBwJAHhXgU3sQ9HcUcOvV2GGTHfLsgUdIWgpqfIQjzjWAJVRZhz9ClnKlmi44lEXtk1Q1kvN+MZjiZIKxNM6j4yJhKQ5ODbZBHRniv/zbNTQSaT3B1ab0/MbThOJuAYaFFJ4XO1W5o6tz2HyT4HNJ38iLcRsnuGM4kYGn0YziZi6HfHNMNvldhSqREKAAA=";
    private static final Log log = LogFactory.getLog(PaginationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel formNbLabel;
    protected JComboBox formsByPageComboBox;
    protected JButton nextPage;
    protected OfferListTableModel offerListTableModel;
    protected JLabel pageNumber;
    protected JFormattedTextField pageWanted;
    protected JButton previousPage;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PaginationUI $JPanel0 = this;
    private HBox $HBox0;
    private JLabel $JLabel0;
    private HBox $HBox1;
    private JLabel $JLabel1;
    private HBox $HBox2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        pageWanted.addKeyListener(new KeyAdapter(){
            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
                    offerListTableModel.setPageToShow((Integer) pageWanted.getValue());
                }
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PaginationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PaginationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PaginationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PaginationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PaginationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PaginationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PaginationUI() {
        $initialize();
    }

    public PaginationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__formsByPageComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        offerListTableModel.setNbFormsPerPage((Integer)formsByPageComboBox.getSelectedItem());
    }

    public void doActionPerformed__on__nextPage(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        offerListTableModel.setPageToShow(offerListTableModel.getPageToShow() + 1);
    }

    public void doActionPerformed__on__previousPage(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        offerListTableModel.setPageToShow(offerListTableModel.getPageToShow() - 1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getFormNbLabel() {
        return formNbLabel;
    }

    public JComboBox getFormsByPageComboBox() {
        return formsByPageComboBox;
    }

    public JButton getNextPage() {
        return nextPage;
    }

    public OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public JLabel getPageNumber() {
        return pageNumber;
    }

    public JFormattedTextField getPageWanted() {
        return pageWanted;
    }

    public JButton getPreviousPage() {
        return previousPage;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOfferListTableModel(OfferListTableModel offerListTableModel) {
        OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = offerListTableModel;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, offerListTableModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected HBox get$HBox1() {
        return $HBox1;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected HBox get$HBox2() {
        return $HBox2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createFormNbLabel() {
        $objectMap.put("formNbLabel", formNbLabel = new JLabel());
        
        formNbLabel.setName("formNbLabel");
    }

    protected void createFormsByPageComboBox() {
        $objectMap.put("formsByPageComboBox", formsByPageComboBox = new JComboBox());
        
        formsByPageComboBox.setName("formsByPageComboBox");
        formsByPageComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formsByPageComboBox"));
    }

    protected void createNextPage() {
        $objectMap.put("nextPage", nextPage = new JButton());
        
        nextPage.setName("nextPage");
        nextPage.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextPage"));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPageNumber() {
        $objectMap.put("pageNumber", pageNumber = new JLabel());
        
        pageNumber.setName("pageNumber");
    }

    protected void createPageWanted() {
        $objectMap.put("pageWanted", pageWanted = new JFormattedTextField(new UIHelper.NumberFormatterFactory()));
        
        pageWanted.setName("pageWanted");
        pageWanted.setColumns(15);
        pageWanted.setColumns(3);
    }

    protected void createPreviousPage() {
        $objectMap.put("previousPage", previousPage = new JButton());
        
        previousPage.setName("previousPage");
        previousPage.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__previousPage"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($HBox0, BorderLayout.WEST);
        add($HBox1, BorderLayout.CENTER);
        add($HBox2, BorderLayout.EAST);
        // inline complete setup of $HBox0
        $HBox0.add(formNbLabel);
        $HBox0.add($JLabel0);
        // inline complete setup of $HBox1
        $HBox1.add($JLabel1);
        $HBox1.add(formsByPageComboBox);
        // inline complete setup of $HBox2
        $HBox2.add(previousPage);
        $HBox2.add(pageWanted);
        $HBox2.add(pageNumber);
        $HBox2.add(nextPage);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        $HBox0.setVerticalAlignment(SwingConstants.CENTER);
        $HBox1.setHorizontalAlignment(SwingConstants.CENTER);
        $HBox1.setVerticalAlignment(SwingConstants.CENTER);
        formsByPageComboBox.setModel(new DefaultComboBoxModel(new Object[]{10,20,50,100,1000,-1}));
        formsByPageComboBox.setRenderer(getVradiContext().getContextValue(NumberListCellRenderer.class));
        $HBox2.setVerticalAlignment(SwingConstants.CENTER);
        previousPage.setIcon(SwingUtil.getUIManagerActionIcon("arrowLeft"));
        nextPage.setIcon(SwingUtil.getUIManagerActionIcon("arrowRight"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createOfferListTableModel();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFormNbLabel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.forms.returned"));
        // inline creation of $HBox1
        $objectMap.put("$HBox1", $HBox1 = new HBox());
        
        $HBox1.setName("$HBox1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.forms.shown"));
        createFormsByPageComboBox();
        // inline creation of $HBox2
        $objectMap.put("$HBox2", $HBox2 = new HBox());
        
        $HBox2.setName("$HBox2");
        createPreviousPage();
        createPageWanted();
        createPageNumber();
        createNextPage();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_NB_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("totalFoundFormNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    formNbLabel.setText(_(getStringValue(offerListTableModel.getTotalFoundFormNb())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("totalFoundFormNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREVIOUS_PAGE_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("pageToShow", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    previousPage.setVisible(offerListTableModel.getPageToShow() > 1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("pageToShow", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_WANTED_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("pageToShow", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    SwingUtil.setText(pageWanted, getStringValue(offerListTableModel.getPageToShow()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("pageToShow", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_NUMBER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("nbPagesAsText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    pageNumber.setText(_(getStringValue(offerListTableModel.getNbPagesAsText())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("nbPagesAsText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_PAGE_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("lastPage", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    nextPage.setVisible(!offerListTableModel.isLastPage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("lastPage", this);
                }
            }
        });
    }

}