/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.search;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.tooltip.FocusableTip;
import org.nuiton.wikitty.entities.BusinessEntity;
import static org.nuiton.i18n.I18n._;

public class MultipleSelectionEditor<B extends BusinessEntity> extends JLabel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_CLASS = "beanClass";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1SPW8TQRAdn2MbO0CAiCiIIAXo96R0yAiCAlZADki4iXDD3u3Kt9F6b9ndC0eD+An8BOhpkOioEAU1BQ3iLyBEQYuYWzs+hxwfV9xK8/HmzZv36is0rIGLezTPicmUE2NO7tzY3b0X7fHY3eQ2NkK71MDkqwUQDGGRzeLWweVhv2gPp+3hVjrWqeJqrrvbh451TyS3CefOwYXDHbG14WCW7uY6MweoM1JVqC++fwues2cvA4BcI7s6rrL+r65yk4U+BII5OIOT9mkoqRohDSPUCPmeKGJbklp7l475I3gKrT40NTUI5uDS/6/sMXx/rh3UZSQdbKRmROIkNXxM9g1lgmSCWE5NnJCdTDqhJR9wiRcQqbrFBOJp7UGaDtoRp8qjOlgqWJKCOfGRsqqVUMUkNw6u/GXYwD9HRm5PehHNwPlDguKpSHmqUsvaEBomw7CD1eHR697H1OSuq7/dtQD02Z8ry5/efnnTOzhmDWefrSyd8yKKrE2qcU1RjF6aXDJzQoY7VHeH0LZ+J2/UtQpig2kayeG8017Oop1sU5sgRKP1+d37lYcf6xD0oCNTynq0qL8NbZcYVCGVLNfXNz2j44+P4f9Uwc3BguM5OuXkVUYdXY+EYmisazlKsFYhwYxH1P7wY3nwenNehnN/LC+laDyAplBSKO5dPTVspYsXteUZS0tjVlm1VrwdrfUvIDmL+CMEAAA=";
    private static final Log log = LogFactory.getLog(MultipleSelectionEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Class beanClass;
    protected SearchMultipleSelectionHandler<B> handler;
    protected MultipleSelectionEditor<B> lbl = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<B> allValues;
    protected java.util.List<B> selectedValues;
    protected FocusableTip focusableTip;
    
    
    @Override
    public String getToolTipText(MouseEvent event) {
        super.getToolTipText(event);
    
        // display it into persistant tooltip
        if (focusableTip == null) {
            focusableTip = new FocusableTip(this, true);
        }
        focusableTip.toolTipRequested(event, handler.getPopupUI());
    
        return null;
    }
    
    void $afterCompleteSetup() {
        selectedValues = new ArrayList<B>();
        setToolTipText(FocusableTip.DUMMY_TOOL_TIP);
    }
    
    public void setHandler(org.chorem.vradi.ui.search.SearchMultipleSelectionHandler handler) {
        this.handler = handler;
    }
    
    public java.util.List<B> getAllValues() {
        return allValues;
    }
    
    public void setAllValues(java.util.List<B> allValues) {
        this.allValues = allValues;
    }
    
    public java.util.List<B> getSelectedValues() {
        return selectedValues;
    }
    
    public void setSelectedValues(java.util.List<B> selectedValues) {
        this.selectedValues = selectedValues;
    }
    
    public void addSelectedValue(B selected) {
        selectedValues.add(selected);
        lbl.setText(handler.getValuesAsString(selectedValues));
    }
    
    public void removeSelectedValue(B unselected) {
        selectedValues.remove(unselected);
        lbl.setText(handler.getValuesAsString(selectedValues));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MultipleSelectionEditor(String param0, Icon param1, int param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MultipleSelectionEditor(JAXXContext parentContext, String param1, Icon param2, int param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionEditor(String param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultipleSelectionEditor(JAXXContext parentContext, String param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionEditor(String param0) {
        super(param0);
        $initialize();
    }

    public MultipleSelectionEditor(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionEditor(Icon param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultipleSelectionEditor(JAXXContext parentContext, Icon param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionEditor(Icon param0) {
        super(param0);
        $initialize();
    }

    public MultipleSelectionEditor(JAXXContext parentContext, Icon param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionEditor() {
        $initialize();
    }

    public MultipleSelectionEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Class getBeanClass() {
        return beanClass;
    }

    public SearchMultipleSelectionHandler<B> getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeanClass(Class beanClass) {
        Class oldValue = this.beanClass;
        this.beanClass = beanClass;
        firePropertyChange(PROPERTY_BEAN_CLASS, oldValue, beanClass);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBeanClass() {
        $objectMap.put("beanClass", beanClass = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SearchMultipleSelectionHandler<B>(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 1 property setters
        setText(_(handler.getValuesAsString(getSelectedValues())));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("lbl", lbl);
        createBeanClass();
        createHandler();
        // inline creation of lbl
        setName("lbl");
        
        $completeSetup();
    }

}