/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class DateTimeEditor extends VradiEditor<Date, DateEditorModel> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_HOUR_ENABLED = "hour.enabled";
    public static final String BINDING_HOUR_SELECTED_ITEM = "hour.selectedItem";
    public static final String BINDING_MINUTE_ENABLED = "minute.enabled";
    public static final String BINDING_MINUTE_SELECTED_ITEM = "minute.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz08TQRTHp7UtlFJ/8CsQ0BQl8UDcwhkCKEiEFCXWkIZenHYGOrC7M87OwuLB+Cf4J+jdi4k3T8aDZw9ejP+CMR68Gt/s9ieuZZPtYdvOe+/zvvPmvdm3P1DakWj2CHueIV1bMYsa23crlUe1I1pXG9SpSyYUlyj4JJIoWUU50l53FLpVLenwYjO8uM4twW1qd0UvldCQo85M6jQoVQpd742oO06x3DYvecKVLWpbVBj19a+fyVfk5ZskQp4AdVnYSuGiqM5OUiWUZEShEch0gosmtg9BhmT2IejN67V1EzvOQ2zRZ+gFGiihjMASYArdjL5ln+HHe0Kh/NyexITdJwx8FhRa4PLQqDe4pJZxoi2Gywx+cEClQX0fx9jAij6BLEGMED4so1Da4oSaCi1GQwThOzqmw8ieYJMRDAaF5nsq1zYYzilUxCjr515rsUPIBznWua38yozounnNoO1dbHenywTOChW05iNoo2PFReDsGdsVrXOX1Y+p1AEj7bjBuYC0oP+P9dpSDe4CcbwnLxxIjd/jnvaZ7MaUcA0w52X6q72+GYvZrvIPfqZpkWi6p0TQtkanbTt9laiitHRhWaHJ6r+d/hhMQY9PnutxDfStfyZGv374/n6z1dhjkHs81LVrLqHhhOSCSsV06itBV7uKmcUdLJaqMB7UhKH2h3YmRFi5aQZxkO+aDjd0uPEAOw1ApAe+ffw08fTLJZTcREMmx2QTa/8tlFUNCVXgJvHE6pqvaPh0EJ5XtTYoponPuAvdcXkZ2gcXaswmUPgVD4owE1KEtpJa9vPv0fK7tVYhEiBs6r/unWKk91GG2SazqT/jzfENnemccKhLeGdMwwY3ob9HRbOTb/vP+bCd5izsMcu1yuy5n8DwXP1V9LXrX4uRUSkoVT/GRATGALVxzaQkJiYHwxBhV1FQeSEpXE2SktgwvXynD2EqEmG1D2E6EmEjFqF1kceWsRVTxiC82giVwd0bgzMcXDOUbClqxWSlFPX0S2U5GOYCVvB+rsG9vBLOvBH7yGdjH3k0wn5sQr/zjkaoxyY0LiD8Bdx4UAVgCgAA";
    private static final Log log = LogFactory.getLog(DateTimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "value",  editorName = "editor")
    protected JXDatePicker editor;
    protected JComboBox hour;
    protected JComboBox minute;
    protected DateEditorModel model;
    @Validator( validatorId = "validator")
    protected SwingValidator<DateEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditor $VradiEditor0 = this;
    private JPanel $JPanel0;
    private JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DateTimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditor() {
        $initialize();
    }

    public DateTimeEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setValue(editor.getDate());
    }

    public void doActionPerformed__on__hour(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setHour((Integer)hour.getSelectedItem());
    }

    public void doActionPerformed__on__minute(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinute((Integer)minute.getSelectedItem());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getEditor() {
        return editor;
    }

    public JComboBox getHour() {
        return hour;
    }

    public JComboBox getMinute() {
        return minute;
    }

    public DateEditorModel getModel() {
        return model;
    }

    public SwingValidator<DateEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
        editorContent.add($JPanel0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JXDatePicker());
        
        editor.setName("editor");
        editor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        editorContent.setLayout(new BorderLayout());
    }

    protected void createHour() {
        $objectMap.put("hour", hour = new JComboBox());
        
        hour.setName("hour");
        hour.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hour"));
    }

    protected void createMinute() {
        $objectMap.put("minute", minute = new JComboBox());
        
        minute.setName("minute");
        minute.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__minute"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new DateEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(DateEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToEditorContent();
        // inline complete setup of $JPanel0
        $JPanel0.add(hour, BorderLayout.WEST);
        $JPanel0.add($JLabel0, BorderLayout.CENTER);
        $JPanel0.add(minute, BorderLayout.EAST);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        editorContent.setMaximumSize(new Dimension(0, 28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setPreferredSize(new Dimension(0,28));
        hour.setMinimumSize(new Dimension(0,28));
        hour.setModel(UIHelper.getHourModel());
        hour.setPreferredSize(new Dimension(60,28));
        hour.setRenderer(UIHelper.get2DigitsRenderer());
        minute.setMinimumSize(new Dimension(0,28));
        minute.setModel(UIHelper.getMinuteModel());
        minute.setPreferredSize(new Dimension(60,28));
        minute.setRenderer(UIHelper.get2DigitsRenderer());
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$VradiEditor0", $VradiEditor0);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createHour();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.common.timeseparator"));
        createMinute();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setDate(model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hour.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("hour", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hour.setSelectedItem(model.getHour());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("hour", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minute.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minute.setSelectedItem(model.getMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minutes", this);
                }
            }
        });
    }

}