/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.FieldTypeEnum;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormLink;
import org.chorem.vradi.entities.ModificationTag;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.editors.DateTimeEditor;
import org.chorem.vradi.ui.offer.editors.IdEditor;
import org.chorem.vradi.ui.offer.editors.StringEditor;
import org.chorem.vradi.ui.offer.editors.TextEditor;
import org.chorem.vradi.ui.offer.editors.UrlEditor;
import org.chorem.vradi.ui.offer.widgets.AttachmentFileHandler;
import org.chorem.vradi.ui.offer.widgets.EmbeddedFileHandler;
import org.chorem.vradi.ui.offer.widgets.RelatedFormHandler;
import org.chorem.vradi.ui.offer.widgets.ReplaceFormHandler;
import org.chorem.vradi.ui.renderers.ThesaurusHighlighter;
import org.chorem.vradi.ui.widgets.MultipleSelectionPane;
import static org.nuiton.i18n.I18n._;

public class OfferEditUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_PREVIOUS_FORM = "previousForm";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_FILE_PANE_BEAN = "attachmentFilePane.bean";
    public static final String BINDING_ATTACHMENT_FILE_PANE_ENABLED = "attachmentFilePane.enabled";
    public static final String BINDING_COUNTRY_EDITOR_ENABLED = "countryEditor.enabled";
    public static final String BINDING_COUNTRY_EDITOR_VALUE = "countryEditor.value";
    public static final String BINDING_DATE_PEREMEPTION_EDITOR_ENABLED = "datePeremeptionEditor.enabled";
    public static final String BINDING_DATE_PEREMEPTION_EDITOR_VALUE = "datePeremeptionEditor.value";
    public static final String BINDING_DATE_PUB_EDITOR_ENABLED = "datePubEditor.enabled";
    public static final String BINDING_DATE_PUB_EDITOR_VALUE = "datePubEditor.value";
    public static final String BINDING_DEPARTMENT_EDITOR_ENABLED = "departmentEditor.enabled";
    public static final String BINDING_DEPARTMENT_EDITOR_VALUE = "departmentEditor.value";
    public static final String BINDING_DESCRIPTION_EDITOR_ENABLED = "descriptionEditor.enabled";
    public static final String BINDING_DESCRIPTION_EDITOR_VALUE = "descriptionEditor.value";
    public static final String BINDING_EMBEDDED_FILE_PANE_BEAN = "embeddedFilePane.bean";
    public static final String BINDING_EMBEDDED_FILE_PANE_ENABLED = "embeddedFilePane.enabled";
    public static final String BINDING_ENTITY_EDITOR_ENABLED = "entityEditor.enabled";
    public static final String BINDING_ENTITY_EDITOR_VALUE = "entityEditor.value";
    public static final String BINDING_FORM_TITLE_LBL_VISIBLE = "formTitleLbl.visible";
    public static final String BINDING_ID_EDITOR_ENABLED = "idEditor.enabled";
    public static final String BINDING_ID_EDITOR_VALUE = "idEditor.value";
    public static final String BINDING_OBJET_EDITOR_ENABLED = "objetEditor.enabled";
    public static final String BINDING_OBJET_EDITOR_VALUE = "objetEditor.value";
    public static final String BINDING_PROPOSITION_LIST_SELECTION_MODEL = "propositionList.selectionModel";
    public static final String BINDING_RELATED_FORM_PANE_BEAN = "relatedFormPane.bean";
    public static final String BINDING_RELATED_FORM_PANE_ENABLED = "relatedFormPane.enabled";
    public static final String BINDING_REPLACE_FORM_PANE_BEAN = "replaceFormPane.bean";
    public static final String BINDING_REPLACE_FORM_PANE_ENABLED = "replaceFormPane.enabled";
    public static final String BINDING_SOURCE_TEXT_EDITOR_ENABLED = "sourceTextEditor.enabled";
    public static final String BINDING_SOURCE_TEXT_EDITOR_VALUE = "sourceTextEditor.value";
    public static final String BINDING_SOURCE_URLEDITOR_ENABLED = "sourceURLEditor.enabled";
    public static final String BINDING_SOURCE_URLEDITOR_VALUE = "sourceURLEditor.value";
    public static final String BINDING_VIEW_PDF_ENABLED = "viewPDF.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1bzY8cRxVvr73fXnu9/ooT2xlvHFjH9tiOEIpwIPF+jHfNrL3ZGRuDA6Zmuma2kp7udnX17myiIC6ICweOkbiEO0JCcEBCHACJnDlwQfwLCHHginhVNf1Rvd01tdOOlPFu16tf/d7vvXr1unv2V/+yxgNqXfkI9ftVGrqM9HD1wb2nTx+1PsJttoqDNiU+86gl/zsyZo09s2bt+HrArDee1fn0W4Ppt1a8nu+52E3Nvlu3ZgK27+BgB2PGrEvqjHYQ3GrEw3f7fkgj1JhUHuoX//n32M/tH/9yzLL6PrC7Aa5Uhs1KPDlWt8aIzawFWGkX3XKQ2wUalLhd4DvHr604KAgeoh5+Yf3ImqxbEz6iAMasRXOXBYaY3/eZNet1Opiu2YQ93mDWmx7tVts7HsW96i5FNqmGpCosqo8SO98X8yeYdcxGDDHr8oFpsDRhBAfVmkd7if0Zn3q+F8CQ59ZJwDY9GzvMush961eDPXC1uoo7KHRYPJzMnthFDrExs05x+yrXp7rseQ5GbmI0hYEjajlCojPJ9eM+xbvECwPOiF87kYzNY0o94ZxHm3wus95VwiYWRjA64Njgn0+ii5s4CFAXi5kZytOxvMw6l/byQcN3CNtCruA5HU+Y6wA9Zewy/7iY+McN+BjkiQLIrznc6PXEZ27bJMzB9RbIfFqxXw4Z81xueSWecEKs3qae48glzquc4xF12kk+bcVzGYRdzntFkU9Ob0ZR+Wo8cdaDbc2k8MyqFmcfFiZBVW4HOYFjvJXoQuwI563hOBt2HsZxkbb7ydAtdXyu7YFHtNhg3sawI1kPcIpBIGfwVtiK2N4eznYVZjRByDzOZwUchtnY59sqsbmb4RZ4IW3jJu4XczspbR5v1yN214eze0ydPGKTbZkQ/Nc31KFTUb2O+TLrxvCFVOqpsF1NdtPteMsk22Dyqkg9MXSDf6wnDlPsgH52Ld5Ud/J47BG7i1lQ3YTCRHwHN7ADpxGwj/bCgzSi76A2jhD55YeqSZrvnZjvepbvnZjvB/HQAmIMtXd4gtWIg5UFGql61mth2wa3im0Gi7yds8jU1Qd11MLO7WyJEVe50XeTbL6aqgpC4WuqwclMyR9U7wQTrnHTHyQ1k+3gAIU0DOLUScrfLIp1d2LqSfk8FcB5FAaytsVGAgMf8E8I/H3+0U1iA6cjP3dIh2Bb1L8DdWx92eurgJPIdUMHi7T8ijp0qkNc+4MQUzgMk4qbMZrcJXhva7WWHqLWa8ra0JNUk54kaRqOPLPGKSwOjc8rzw62MdswJBuYVzINDAcUo/87d/rvf/jn72pR1/I5rH021zTVdEE3wQOLKT/lIcqyZQkZcW5tIv/uM2s6EHtEdGQXc4g1BsNADtaTJzqfXl1HwQ5AjE/+409/OffDvx21xmrWjOMhu4a4/QbPDwoqeI7d9997XzA6vjcFn/Pw/1HInw5YM3mMj3eQE8C/E56PXoSpC3Mtj9qYbiECRcqOrvdBp4s5OsVkW9Nf/vd04zfvR1odAe4XCs0Tvca/Z00Q1yEuFj3eoH3L7elm/QCHtpe0aXmNmwWt29SDJjQ/y4gO2o198flZniTzvBYTN4T2p472PchD6xijXI8FaBObXtjeWev7yLWlaoOxWZvsQr9FG+QT+G3sztv9kK/wE+E3/+mnnMZMUsyGEDkGLQgUVvIJkEHOPYd03Z7oXm9+OlOpiKpQqVbEJoN/RY8FTQXsaJcFcGFl7WFzbXvmMx5hQLgZSFpvQ5k6l8DyQ2JrUG/gdOTIcrcrCLMCYQ+T7g7XosWTKc+5CTkXfhpnvI8azb/rRv7V12rNw3l3WvEumn9436aFb3XcYaP5d8PIv+2N++uHdPCM4mAMcHgPZ4SH23yC1sWxKNDgqjz9xW/VPey0vR7m7Za8PVlxvAA/gvqHBqGwveeux3bA5+ee+7zNhw9yAt97UHFqFLa7P2S3HAEqz3cE+4VPZxahC+FTq6B4uDjzWR72MT42DPYo394gMtRs6SCfVO0Q7vJUz8U9zyVtZh2pJcufzywvrAs4THED3naY87iQ4SG7PtkrpBk9ShhdyWOUzCvgdpqbNna8vUeRIb+X1dMcj2m+KmnK/qMKBbVDumEU/jTPFUg3abXBy641IW0hbRnU6ybxmwLvcjEeJJ2fOPtmrrPKhAKHz0bBWEkbm7t8LhsZx2ujbKJk3Z1mFLkB76qzHhfCRZ5ezvVUWhW4OB+5WEduN4S7cAPvJrHLzzk49e/z+nKlgtptuHmqi3WWnnCSUrB1YAX3H9D6D8bgJzmydO3ajcpihz6vbS9e4yVJVWwQVMm82qEZiSbJnXfcm/yyKtCr+bPVdMjP/di4QKeFrE617WFKTbxEpbD7/P7ycKXCj9XcepwrHLcyEC78+BDChR+bCvf42wbCDZw8r/DqhI4D970Yu6LlD4hots5LZUnw2LVx26P8dnRJKJVWYiujxEwaTBXjtYJFVTUWc9VIrIfJUYstzeW4oDBz4Q4Z5QgCPZsiRmWpckCOhxk55h2MdvHNYlEuFS6tyrKUnyQZ9AJxzkTiPEzhm5fbUwpH3CeZA/Bpxulj0kR19OwBENXBi7kOcrsCp45HTq2BzYjdBcihurKp6y7AWttdiEfKpjwWUjykKIFK5V5C5UKWipxQQGaWm9yTkOZ85tN87B5xC9kcpu2aFlw4nDmTUykmbYeITj5zsI8mzMmYzIqAHU2cLvVCX2V0f1RGJ2JG9zmqOaHTmSxu7vvFffLhOM3FnA6X0GdSlPo9p8EoRr0DhWI0Tgsxp6cR8mj5JB/Dqawa5fOpIWBH0yp+qqiyapbXqhkhj5boGBZ0VFJrJarAGoczZ3IuyySvKo1cCpKNd0ha51O0SM/3KFvr80+V18ZoOombho0UqjmvywW84AQ9SG9tVNlmRCBfFjX5S6FyI1CT2plTe72IGsUEGr2+ym271Im8LSFH61TkqmkyWJNi/LKuU+F3RaO2f7lM1PZPmujaP24xpP0TJhpHjkeOlHEmICxzbAZZZ6SJzhluYeIMtxvmTANszJ1ZUHiglniAnunaFG/GBza5zz/SMKo/l3L9EYa6JoI7dI8bGTxSzDl/bNwKu4XHySofNQfOxB3O60LaApmf6AY3kNMdrx0G6jsdRfEp8cS1iVpZ0dV7zhchYevxpjjJX1x6u5iuRY859K+HkkhVUpFqefa+jFTEoagmROPDHB5j1oQzeE/zOn884OK9yrLXl+9ulrh/LURvVG6L++KI09kUp4FJAZHJwbBBWGMeJ97l3/WptKC4Erf7rQOwR/jnjAFi7hunhXfl27EKYoySVshwwQqXDFaY9Si/7RAPO8Fo7MPRoY5TzN9TfEe8auBYrdGxDryE0+BVDPBODl7P8Sdukasjw/HJqDSCUxrhmSZgiyaxh1aT9MIef2dZEmrOp7iDKcX2ywBTCopGpjdNNqV8m10SRVRsjVsmGNFTu5IwF5IXgPLbJMuIbnkOae9rgJeMEupnGoTrJh4OHoFrYKomVQ+0xm4A27RGsGMP3veXQZyLEV8C2HyHs1pNvpZVEm+685K8HN9FTlgOhE/+tQbhjhHCb0sj/L40wh9LI/y5NMKXpRF0sfha6ViYIehiYYagi4UZgi4WZgi6WJgh6GLx9dKxMEPQxcIMQRcLMwRdLMwQdLEwQ9DF4p3SsTBD0MXCDEEXCzMEXSzMEHSxMEPQxeIbpWNhhqCLhRmCLhZmCLpYmCHoYmGGoIvFN0vHwgxBFwszBF0szBB0sTBD0MXCDEEXi/dKx8IMQRcLMwRdLMwQdLEwQ9DFwgxBF4t7pWNhhqCLhRmCLhZmCLpYmCHoYmGGoHtssWqE8MWL4rt5MwRdPtRK54MZgi4fzBB0+WCGoMsHMwRdPpghIE00h37nVCB0NRzMEHQP44Yj8O9VY6R7DrBpgDHFMfiXJkrhDMtuEyaTO8i15d/olCJyVJfiW0YIuhQ3QtCKYcbhr6U56FJ86HdLh6a4GYIuxY0QtNF8UjqaRgjaaJpx0EXTDEGnw9PSOhghaHUw46DTwYzDLzQZ9aHJC6M2dpxt7NqYamsNMnn22eN/TF4S5EQQ/a3qZmm0F0M6Hbs0wk7pIH1koEneXzFpIId+bWkoKa80wovSO2jot9OGcuAI/weROHcZoUMAAA==";
    private static final Log log = LogFactory.getLog(OfferEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table actionPanel;
    protected JButton annuler;
    protected MultipleSelectionPane<File, Form> attachmentFilePane;
    protected JPanel content;
    protected StringEditor countryEditor;
    protected Form data;
    protected DateTimeEditor datePeremeptionEditor;
    protected DateTimeEditor datePubEditor;
    protected StringEditor departmentEditor;
    protected TextEditor descriptionEditor;
    protected Boolean editable;
    protected MultipleSelectionPane<File, Form> embeddedFilePane;
    protected StringEditor entityEditor;
    protected SwingValidatorMessageTableModel errorEditorTable;
    protected JButton findQueriesButton;
    protected Table formContentPane;
    protected JPanel formPane;
    protected JScrollPane formScrollPane;
    protected JSplitPane formSplitPane;
    protected JButton formTitleLbl;
    protected IdEditor idEditor;
    protected HBox lastModified;
    protected StringEditor objetEditor;
    protected JSplitPane offerEdit;
    protected OfferEditUI offerEditUI = this;
    protected Form previousForm;
    protected JList propositionList;
    protected DefaultListModel propositionListModel;
    protected MultipleSelectionPane<FormLink, Form> relatedFormPane;
    protected MultipleSelectionPane<FormLink, Form> replaceFormPane;
    protected StringEditor sourceTextEditor;
    protected UrlEditor sourceURLEditor;
    protected JPanel statusButtonPanel;
    protected JPanel thesaurus;
    protected Boolean valide;
    protected JButton viewPDF;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSplitPane $JSplitPane0;
    private Table $Table0;
    private JSplitPane $JSplitPane1;
    private Table $Table1;
    private Table $Table2;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditHandler getHandler() {
        return getContextValue(OfferEditHandler.class);
    }
    
    public OfferListHandler getListHandler() {
        return UIHelper.getHandler(this, OfferListHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        if(data != null && data.getCreationDate() != null) {
            String creationDateText = String.format(_("vradi.entity.creation.date"),
                    data.getCreationDate());
            lastModified.add(new JLabel(creationDateText));
    
            if (data.getExtensionNames().contains(ModificationTag.EXT_MODIFICATIONTAG)) {
                // get modification info
                ModificationTag formTag = VradiService.getWikittyProxy().cast(data, ModificationTag.class);
                Object date = formTag.getLastModified();
                Object user = formTag.getLastModifier();
                if (date != null && user != null) {
                    String lastModifiedText = String.format(_("vradi.entity.lastModified.date.user"), date, user);
                    lastModified.add(new JLabel(lastModifiedText));
                }
            }
        }
        setContextValue(errorEditorTable, "errorEditorTable");
        formScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        formScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        formSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                resize();
            }
        });
        addPropertyChangeListener("previousForm", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                formTitleLbl.setText(getFormTitle());
            }
        });
    }
    
    public void resize(){
        Dimension dimension = formContentPane.getSize();
        dimension.setSize(formSplitPane.getDividerLocation() - 20, formContentPane.getHeight());
        formContentPane.setPreferredSize(dimension);
        formContentPane.revalidate();
    }
    
    public void updateThesaurusSize(){
        double total = getSize().getWidth();
        Component[] thesPanels = thesaurus.getComponents();
        double width = total / thesPanels.length;
        for (Component c : thesPanels){
            ThesaurusUI thesaurus = (ThesaurusUI)c;
            Dimension d = thesaurus.getSize();
            if (log.isDebugEnabled()){
                log.debug("Resizing total width : " + total + " thesaurus width : " + width);
            }
            d.setSize(width, d.getHeight());
            thesaurus.setPreferredSize(d);
        }
        validate();
    }
    
    protected String getFormTitle() {
        return _("vradi.offerEdit.otherIndexationTitle", getPreviousForm() == null ? "null" : getPreviousForm().getId());
    }
    
    protected void openPreviousOffer() {
        OfferListUI offerListUI = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(getVradiContext());
        getListHandler().addEditPane(offerListUI, getPreviousForm().getWikittyId());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OfferEditUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OfferEditUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OfferEditUI() {
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__findQueriesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().findQueries(this);
    }

    public void doActionPerformed__on__formTitleLbl(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        openPreviousOffer();
    }

    public void doActionPerformed__on__viewPDF(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().viewInPDF(this);
    }

    public void doComponentResized__on__formScrollPane(ComponentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        resize();
    }

    public void doTableChanged__on__errorEditorTable(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setValide(errorEditorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getActionPanel() {
        return actionPanel;
    }

    public JButton getAnnuler() {
        return annuler;
    }

    public MultipleSelectionPane<File, Form> getAttachmentFilePane() {
        return attachmentFilePane;
    }

    public JPanel getContent() {
        return content;
    }

    public StringEditor getCountryEditor() {
        return countryEditor;
    }

    public Form getData() {
        return data;
    }

    public DateTimeEditor getDatePeremeptionEditor() {
        return datePeremeptionEditor;
    }

    public DateTimeEditor getDatePubEditor() {
        return datePubEditor;
    }

    public StringEditor getDepartmentEditor() {
        return departmentEditor;
    }

    public TextEditor getDescriptionEditor() {
        return descriptionEditor;
    }

    public Boolean getEditable() {
        return editable;
    }

    public MultipleSelectionPane<File, Form> getEmbeddedFilePane() {
        return embeddedFilePane;
    }

    public StringEditor getEntityEditor() {
        return entityEditor;
    }

    public SwingValidatorMessageTableModel getErrorEditorTable() {
        return errorEditorTable;
    }

    public JButton getFindQueriesButton() {
        return findQueriesButton;
    }

    public Table getFormContentPane() {
        return formContentPane;
    }

    public JPanel getFormPane() {
        return formPane;
    }

    public JScrollPane getFormScrollPane() {
        return formScrollPane;
    }

    public JSplitPane getFormSplitPane() {
        return formSplitPane;
    }

    public JButton getFormTitleLbl() {
        return formTitleLbl;
    }

    public IdEditor getIdEditor() {
        return idEditor;
    }

    public HBox getLastModified() {
        return lastModified;
    }

    public StringEditor getObjetEditor() {
        return objetEditor;
    }

    public JSplitPane getOfferEdit() {
        return offerEdit;
    }

    public Form getPreviousForm() {
        return previousForm;
    }

    public JList getPropositionList() {
        return propositionList;
    }

    public DefaultListModel getPropositionListModel() {
        return propositionListModel;
    }

    public MultipleSelectionPane<FormLink, Form> getRelatedFormPane() {
        return relatedFormPane;
    }

    public MultipleSelectionPane<FormLink, Form> getReplaceFormPane() {
        return replaceFormPane;
    }

    public StringEditor getSourceTextEditor() {
        return sourceTextEditor;
    }

    public UrlEditor getSourceURLEditor() {
        return sourceURLEditor;
    }

    public JPanel getStatusButtonPanel() {
        return statusButtonPanel;
    }

    public JPanel getThesaurus() {
        return thesaurus;
    }

    public Boolean getValide() {
        return valide;
    }

    public JButton getViewPDF() {
        return viewPDF;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    public Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(Form data) {
        Form oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setPreviousForm(Form previousForm) {
        Form oldValue = this.previousForm;
        this.previousForm = previousForm;
        firePropertyChange(PROPERTY_PREVIOUS_FORM, oldValue, previousForm);
    }

    public void setValide(Boolean valide) {
        Boolean oldValue = this.valide;
        this.valide = valide;
        firePropertyChange(PROPERTY_VALIDE, oldValue, valide);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(statusButtonPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(lastModified, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(annuler, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(findQueriesButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(viewPDF, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormContentPane() {
        if (!allComponentsCreated) {
            return;
        }
        formContentPane.add(objetEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(idEditor, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(entityEditor, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(countryEditor, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(departmentEditor, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePubEditor, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePeremeptionEditor, new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceTextEditor, new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceURLEditor, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(content, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(descriptionEditor, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormPane() {
        if (!allComponentsCreated) {
            return;
        }
        formPane.add(formTitleLbl, BorderLayout.NORTH);
        formPane.add(formScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFormScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        formScrollPane.getViewport().add(formContentPane);
    }

    protected void addChildrenToFormSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        formSplitPane.add(formPane, JSplitPane.LEFT);
        formSplitPane.add($JSplitPane0, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEdit() {
        if (!allComponentsCreated) {
            return;
        }
        offerEdit.add(formSplitPane, JSplitPane.LEFT);
        offerEdit.add(thesaurus, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(offerEdit, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToStatusButtonPanel() {
        if (!allComponentsCreated) {
            return;
        }
        statusButtonPanel.add($JLabel1);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new Table());
        
        actionPanel.setName("actionPanel");
    }

    protected void createAnnuler() {
        $objectMap.put("annuler", annuler = new JButton());
        
        annuler.setName("annuler");
        annuler.setText(_("vradi.action.cancel"));
    }

    protected void createAttachmentFilePane() {
        $objectMap.put("attachmentFilePane", attachmentFilePane = new MultipleSelectionPane<File, Form>());
        
        attachmentFilePane.setName("attachmentFilePane");
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
        content.setVisible(false);
    }

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new StringEditor());
        
        countryEditor.setName("countryEditor");
    }

    protected void createData() {
        $objectMap.put("data", data = getContextValue(Form.class));
    }

    protected void createDatePeremeptionEditor() {
        $objectMap.put("datePeremeptionEditor", datePeremeptionEditor = new DateTimeEditor());
        
        datePeremeptionEditor.setName("datePeremeptionEditor");
    }

    protected void createDatePubEditor() {
        $objectMap.put("datePubEditor", datePubEditor = new DateTimeEditor());
        
        datePubEditor.setName("datePubEditor");
    }

    protected void createDepartmentEditor() {
        $objectMap.put("departmentEditor", departmentEditor = new StringEditor());
        
        departmentEditor.setName("departmentEditor");
    }

    protected void createDescriptionEditor() {
        $objectMap.put("descriptionEditor", descriptionEditor = new TextEditor());
        
        descriptionEditor.setName("descriptionEditor");
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createEmbeddedFilePane() {
        $objectMap.put("embeddedFilePane", embeddedFilePane = new MultipleSelectionPane<File, Form>());
        
        embeddedFilePane.setName("embeddedFilePane");
    }

    protected void createEntityEditor() {
        $objectMap.put("entityEditor", entityEditor = new StringEditor());
        
        entityEditor.setName("entityEditor");
    }

    protected void createErrorEditorTable() {
        $objectMap.put("errorEditorTable", errorEditorTable = new SwingValidatorMessageTableModel());
        
        errorEditorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorEditorTable"));
    }

    protected void createFindQueriesButton() {
        $objectMap.put("findQueriesButton", findQueriesButton = new JButton());
        
        findQueriesButton.setName("findQueriesButton");
        findQueriesButton.setText(_("vradi.offerEdit.affectedQueries"));
        findQueriesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__findQueriesButton"));
    }

    protected void createFormContentPane() {
        $objectMap.put("formContentPane", formContentPane = new Table());
        
        formContentPane.setName("formContentPane");
    }

    protected void createFormPane() {
        $objectMap.put("formPane", formPane = new JPanel());
        
        formPane.setName("formPane");
        formPane.setLayout(new BorderLayout());
    }

    protected void createFormScrollPane() {
        $objectMap.put("formScrollPane", formScrollPane = new JScrollPane());
        
        formScrollPane.setName("formScrollPane");
        formScrollPane.addComponentListener(JAXXUtil.getEventListener(ComponentListener.class, "componentResized", this, "doComponentResized__on__formScrollPane"));
    }

    protected void createFormSplitPane() {
        $objectMap.put("formSplitPane", formSplitPane = new JSplitPane());
        
        formSplitPane.setName("formSplitPane");
        formSplitPane.setContinuousLayout(true);
        formSplitPane.setDividerLocation(750);
        formSplitPane.setOneTouchExpandable(true);
        formSplitPane.setResizeWeight(0.8);
        formSplitPane.setDividerSize(12);
    }

    protected void createFormTitleLbl() {
        $objectMap.put("formTitleLbl", formTitleLbl = new JButton());
        
        formTitleLbl.setName("formTitleLbl");
        formTitleLbl.setBorderPainted(false);
        formTitleLbl.setOpaque(false);
        formTitleLbl.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTitleLbl"));
    }

    protected void createIdEditor() {
        $objectMap.put("idEditor", idEditor = new IdEditor());
        
        idEditor.setName("idEditor");
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createObjetEditor() {
        $objectMap.put("objetEditor", objetEditor = new StringEditor());
        
        objetEditor.setName("objetEditor");
    }

    protected void createOfferEdit() {
        $objectMap.put("offerEdit", offerEdit = new JSplitPane());
        
        offerEdit.setName("offerEdit");
        offerEdit.setOneTouchExpandable(true);
        offerEdit.setResizeWeight(0.3);
        offerEdit.setContinuousLayout(true);
        offerEdit.setDividerSize(12);
    }

    protected void createPreviousForm() {
        $objectMap.put("previousForm", previousForm = null);
    }

    protected void createPropositionList() {
        $objectMap.put("propositionList", propositionList = new JList());
        
        propositionList.setName("propositionList");
    }

    protected void createPropositionListModel() {
        $objectMap.put("propositionListModel", propositionListModel = new DefaultListModel());
    }

    protected void createRelatedFormPane() {
        $objectMap.put("relatedFormPane", relatedFormPane = new MultipleSelectionPane<FormLink, Form>());
        
        relatedFormPane.setName("relatedFormPane");
    }

    protected void createReplaceFormPane() {
        $objectMap.put("replaceFormPane", replaceFormPane = new MultipleSelectionPane<FormLink, Form>());
        
        replaceFormPane.setName("replaceFormPane");
    }

    protected void createSourceTextEditor() {
        $objectMap.put("sourceTextEditor", sourceTextEditor = new StringEditor());
        
        sourceTextEditor.setName("sourceTextEditor");
    }

    protected void createSourceURLEditor() {
        $objectMap.put("sourceURLEditor", sourceURLEditor = new UrlEditor());
        
        sourceURLEditor.setName("sourceURLEditor");
    }

    protected void createStatusButtonPanel() {
        $objectMap.put("statusButtonPanel", statusButtonPanel = new JPanel());
        
        statusButtonPanel.setName("statusButtonPanel");
        statusButtonPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new JPanel());
        
        thesaurus.setName("thesaurus");
        thesaurus.setLayout(new BoxLayout(thesaurus, BoxLayout.X_AXIS));
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    protected void createViewPDF() {
        $objectMap.put("viewPDF", viewPDF = new JButton());
        
        viewPDF.setName("viewPDF");
        viewPDF.setText(_("vradi.offerEdit.view.pdf"));
        viewPDF.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__viewPDF"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToOfferEditUI();
        addChildrenToOfferEdit();
        addChildrenToFormSplitPane();
        addChildrenToFormPane();
        addChildrenToFormScrollPane();
        addChildrenToFormContentPane();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add($JSplitPane1, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add(relatedFormPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(replaceFormPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JSplitPane1
        $JSplitPane1.add($Table1, JSplitPane.LEFT);
        $JSplitPane1.add($Table2, JSplitPane.RIGHT);
        // inline complete setup of $Table1
        $Table1.add(attachmentFilePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(embeddedFilePane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(propositionList);
        addChildrenToActionPanel();
        addChildrenToStatusButtonPanel();
        
        // apply 31 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 63 property setters
        offerEdit.setOrientation(JSplitPane.VERTICAL_SPLIT);
        formPane.setMinimumSize(new Dimension(0,0));
        formPane.setPreferredSize(new Dimension(0,0));
        formTitleLbl.setText(_(getFormTitle()));
        formScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        formContentPane.setPreferredSize(new Dimension(0,0));
        objetEditor.setExtensionFieldName(Form.FIELD_INFOGENE_OBJET);
        objetEditor.setExtensionName(Form.EXT_INFOGENE);
        objetEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        objetEditor.setFieldName(Form.FQ_FIELD_INFOGENE_OBJET);
        idEditor.setExtensionFieldName(Form.FIELD_INFOGENE_ID);
        idEditor.setExtensionName(Form.EXT_INFOGENE);
        idEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        idEditor.setFieldName(Form.FQ_FIELD_INFOGENE_ID);
        entityEditor.setExtensionFieldName(Form.FIELD_INFOGENE_ENTITY);
        entityEditor.setExtensionName(Form.EXT_INFOGENE);
        entityEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        entityEditor.setFieldName(Form.FQ_FIELD_INFOGENE_ENTITY);
        countryEditor.setExtensionFieldName(Form.FIELD_INFOGENE_COUNTRY);
        countryEditor.setExtensionName(Form.EXT_INFOGENE);
        countryEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        countryEditor.setFieldName(Form.FQ_FIELD_INFOGENE_COUNTRY);
        departmentEditor.setExtensionFieldName(Form.FIELD_INFOGENE_DEPARTMENT);
        departmentEditor.setExtensionName(Form.EXT_INFOGENE);
        departmentEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        departmentEditor.setFieldName(Form.FQ_FIELD_INFOGENE_DEPARTMENT);
        datePubEditor.setExtensionFieldName(Form.FIELD_FORM_DATEPUB);
        datePubEditor.setExtensionName(Form.EXT_FORM);
        datePubEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePubEditor.setFieldName(Form.FQ_FIELD_FORM_DATEPUB);
        datePeremeptionEditor.setExtensionFieldName(Form.FIELD_FORM_DATEPEREMPTION);
        datePeremeptionEditor.setExtensionName(Form.EXT_FORM);
        datePeremeptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePeremeptionEditor.setFieldName(Form.FQ_FIELD_FORM_DATEPEREMPTION);
        sourceTextEditor.setExtensionFieldName(Form.FIELD_INFOGENE_SOURCETEXT);
        sourceTextEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceTextEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        sourceTextEditor.setFieldName(Form.FQ_FIELD_INFOGENE_SOURCETEXT);
        sourceURLEditor.setExtensionFieldName(Form.FIELD_INFOGENE_SOURCEURL);
        sourceURLEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceURLEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.URL.getFieldType()));
        sourceURLEditor.setFieldName(Form.FQ_FIELD_INFOGENE_SOURCEURL);
        descriptionEditor.setExtensionFieldName(Form.FIELD_INFOGENE_DESCRIPTION);
        descriptionEditor.setExtensionName(Form.EXT_INFOGENE);
        descriptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.TEXT.getFieldType()));
        descriptionEditor.setFieldName(Form.FQ_FIELD_INFOGENE_DESCRIPTION);
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        relatedFormPane.setBeanType(Form.class);
        relatedFormPane.setHandler(new RelatedFormHandler(relatedFormPane));
        replaceFormPane.setBeanType(Form.class);
        replaceFormPane.setHandler(new ReplaceFormHandler(replaceFormPane));
        $JSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
        attachmentFilePane.setBeanType(Form.class);
        attachmentFilePane.setHandler(new AttachmentFileHandler(attachmentFilePane));
        embeddedFilePane.setBeanType(Form.class);
        embeddedFilePane.setHandler(new EmbeddedFileHandler(embeddedFilePane));
        propositionList.setCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.PROPOSITION));
        propositionList.setModel(getPropositionListModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("offerEditUI", offerEditUI);
        createData();
        createPropositionListModel();
        createValide();
        createEditable();
        createPreviousForm();
        createErrorEditorTable();
        createOfferEdit();
        createFormSplitPane();
        createFormPane();
        createFormTitleLbl();
        createFormScrollPane();
        createFormContentPane();
        createObjetEditor();
        createIdEditor();
        createEntityEditor();
        createCountryEditor();
        createDepartmentEditor();
        createDatePubEditor();
        createDatePeremeptionEditor();
        createSourceTextEditor();
        createSourceURLEditor();
        createContent();
        createDescriptionEditor();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setResizeWeight(0.8);
        $JSplitPane0.setContinuousLayout(true);
        $JSplitPane0.setDividerSize(12);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createRelatedFormPane();
        createReplaceFormPane();
        // inline creation of $JSplitPane1
        $objectMap.put("$JSplitPane1", $JSplitPane1 = new JSplitPane());
        
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setOneTouchExpandable(true);
        $JSplitPane1.setResizeWeight(0.8);
        $JSplitPane1.setContinuousLayout(true);
        $JSplitPane1.setDividerSize(12);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createAttachmentFilePane();
        createEmbeddedFilePane();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.edit.proposition"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createPropositionList();
        createThesaurus();
        createActionPanel();
        createStatusButtonPanel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.status.validate"));
        createLastModified();
        createAnnuler();
        createFindQueriesButton();
        createViewPDF();
        // inline creation of offerEditUI
        setName("offerEditUI");
        setLayout(new BorderLayout());
        
        // registers 31 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 31 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORM_TITLE_LBL_VISIBLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                formTitleLbl.setVisible(!isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OBJET_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                objetEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJET_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("objet", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    objetEditor.setValue(data.getObjet());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("objet", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ID_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                idEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ID_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    idEditor.setValue(data.getId());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ENTITY_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                entityEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ENTITY_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("entity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    entityEditor.setValue(data.getEntity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("entity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COUNTRY_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                countryEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COUNTRY_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("country", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    countryEditor.setValue(data.getCountry());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("country", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEPARTMENT_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                departmentEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEPARTMENT_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("department", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    departmentEditor.setValue(data.getDepartment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("department", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DATE_PUB_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                datePubEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PUB_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("datePub", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    datePubEditor.setValue(data.getDatePub());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("datePub", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DATE_PEREMEPTION_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                datePeremeptionEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PEREMEPTION_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("datePeremption", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    datePeremeptionEditor.setValue(data.getDatePeremption());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("datePeremption", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SOURCE_TEXT_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                sourceTextEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_TEXT_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("sourceText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    sourceTextEditor.setValue(data.getSourceText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("sourceText", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SOURCE_URLEDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                sourceURLEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_URLEDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("sourceURL", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    sourceURLEditor.setValue(data.getSourceURL());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("sourceURL", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DESCRIPTION_EDITOR_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                descriptionEditor.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    descriptionEditor.setValue(data.getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RELATED_FORM_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                relatedFormPane.setBean(getData());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RELATED_FORM_PANE_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                relatedFormPane.setEnabled(isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPLACE_FORM_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                replaceFormPane.setBean(getData());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPLACE_FORM_PANE_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                replaceFormPane.setEnabled(isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_FILE_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                attachmentFilePane.setBean(getData());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_FILE_PANE_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                attachmentFilePane.setEnabled(isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EMBEDDED_FILE_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                embeddedFilePane.setBean(getData());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EMBEDDED_FILE_PANE_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                embeddedFilePane.setEnabled(isEditable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROPOSITION_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (propositionList != null) {
                    propositionList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (propositionList != null) {
                    propositionList.setSelectionModel(new OneClicListSelectionModel(propositionList.getSelectionModel(), propositionListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (propositionList != null) {
                    propositionList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VIEW_PDF_ENABLED, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                viewPDF.setEnabled(isEditable());
            }
        });
    }

}