/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.beans.FormPagedResult;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.OfferListColumnFactory;
import org.chorem.vradi.ui.offer.OfferTable;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.wikitty.WikittyProxy;
import static org.chorem.vradi.VradiConstants.SendingStatus;
import static org.nuiton.i18n.I18n._;

public class SendingViewUI extends EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_FIELD_TEXT = "descriptionField.text";
    public static final String BINDING_RECEPTION_PROOF_FIELD_SELECTED = "receptionProofField.selected";
    public static final String BINDING_STATUS_FIELD_TEXT = "statusField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWQW8bRRTHJ27sxA0OoaZpoGmVtpYqobJOAgihhJLGJCSR20ZxGlX1hfHuxJ4y3llmZptND4iPwEeAOxckbpwQB84cuCC+AkIcuCLezNq73mRjr2of1vbMe7/9vzdv3sz3f6G8FOjWcxwElvBdRbvE2nvw9Onj1nNiq0+JtAX1FBco/EzkUK6JZpxoXCp0p1nX7tWee7XGux53iTvgvVZHl6U6ZUR2CFEK3Uh62FJWG9H0WuD5ok+NRKVRv/3n79w3ztff5RAKPFC3AKEsjfKKI5msoxx1FLoCb3qBqwy7bZAhqNsGvSU9VmNYyke4S75EX6GpOip4WABModvZQzYM4x94Cs1VtrqYshp3FZg/2V1W6C4XbcvucEG61guBHWr51CLaymoQ1wE5R5ScPNn1PIMpKDTPj4+JqFOpapz5XXcb2/DGU4WW01DG2Hqc6hIzyxHzELcYecgdwhR6/2JgV1vImBu7xdDJFsGuQrfOUSB2qiiR/QhjlylJpKR8lJexib1Klb2GLThj+9glkNNrevUCS54A2xqY0ubFyGu6sqcHGThcSTiYUW20EOuqmADBdCFRYaGHmdOW1yOHPGhl5Cy5jlsh+eY5FSv6/43k3IyE/PRyBGuUQG36SnE3aV+q7FCHi3AKtN5M0TpgkS5kNRISRzMrQxG9wtWjS/px72yCVqIpaxBs4l7W/+/ox/JAhAorX25TwpyU6bIgNvEULPa+4PzYmCl0NZGIWofYX2zyIOnZ07M6RM9K9MKP0ivJGLydNJjrNz/QlCrnkATqgSBY23+czl2NuHH+iqy/iRSqjNjHUbltetDyricWGZqpFTfTuNtNNFFe+DAMFdw8338PYCrsvAtnOq8Gmtn/5su///Tnj9uD7fZqqunAaQFt0BPcI0JvXIVeD3utryirPsTeWhMVJWHEDo+SxRRhjd40iIP3vaHdLe1u7WDZAUR+6o+ff5n//LdLKLeNLjOOnbC37aKi6gjIAmdO4H2yYRS9djINzzmtTaECw6cc9gGaXXewwkstakr8fgBJWExJQqSkVfz133Ljh41+IiZA2FsXmsfJyD9DBeoy6hJz8vQOldSTZsaTxHd4fHikHScT+nvR67XBunnup0U6qaAm9Wwj8PXXoRGtfx0Zxu0sDGqHDeMCxt0MjCni6sp1xsLo4WfQV9fDVC5hBWd2y1fk/hjCOtQhh9QbIuydLBiotpPxMQWFRZsMW7AslFJIOaKS9rrFK8P08MEQwrvZFk0/aDrhveyECzR8kCEl02GvGVqAH44dy/iE9bGzsZEhG7PYV/yASPrS3NuG0LYy0N60zcVSXxDgmBtddVmYJXvwsjomrHxMGZP6Lu1xoXYIbXeGbbEsyGJbUAcu1FyMCboGZz19CanDLLwlbI1slFmweXNJHxMyrZvaZ4KOEvM/dZsggEwOAAA=";
    private static final Log log = LogFactory.getLog(SendingViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Sending bean;
    protected JTextArea descriptionField;
    protected OfferTable listTable;
    protected OfferListColumnFactory offerListColumnFactory;
    protected OfferListTableModel offerListTableModel;
    protected JCheckBox receptionProofField;
    protected JButton sendSending;
    protected Table sendingContent;
    protected Session session;
    protected JLabel statusField;
    protected JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SendingViewUI $EmailContentUI0 = this;
    private JScrollPane $JScrollPane0;
    private JPanel $JPanel0;
    private Table $Table0;
    private JPanel $JPanel1;
    private HidorButton $HidorButton0;
    private JPanel $JPanel2;
    private Table $Table1;
    private JLabel $JLabel0;
    private Table $Table2;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    
    
    @Override
    public void openUI(VradiTreeNode node) {
        getHandler().displaySession(this, getHelper(), node);
    }
    
    public void setHelper(EmailNavigationTreeHelper helper){
        this.helper = helper;
    }
    
    public EmailNavigationTreeHelper getHelper(){
        if (helper != null){
            return helper;
        }
        helper = getContextValue(EmailNavigationTreeHelper.class);
        if (helper != null){
            return helper;
        }
        return getParentContainer(EmailPopupUI.class).helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void init() {
        title.setText(updateTitle());
        sendSending.setEnabled(canBeReSend());
    }
    
    protected String updateTitle() {
        if (getBean() == null){
            return "";
        }
        String title = "";
        WikittyProxy proxy = VradiService.getWikittyProxy();
        String userId = getBean().getUser();
        if (userId != null){
            User user = proxy.restore(User.class, userId);
            if (user != null) {
                title = _("vradi.email.titleUser", user.getName());
            }
        }
        return title;
    }
    
    protected boolean canBeReSend(){
        if (getBean() == null){
            return false;
        }
        return SendingStatus.isSent(getBean());
    }
    
    public boolean isNotClosed() {
        if (getBean() == null) {
            return false;
        }
        return !SendingStatus.isClosed(getBean());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SendingViewUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SendingViewUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SendingViewUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SendingViewUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SendingViewUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SendingViewUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SendingViewUI() {
        $initialize();
    }

    public SendingViewUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__receptionProofField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateReceptionProof(getBean(),                                                         receptionProofField.isSelected());
    }

    public void doActionPerformed__on__sendSending(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().sendSending(this, getBean());
    }

    public void doFocusLost__on__descriptionField(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateParagraph(getBean(),                                                          getBean().getParagraph());
    }

    public void doKeyReleased__on__descriptionField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setParagraph(descriptionField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Sending getBean() {
        return bean;
    }

    public JTextArea getDescriptionField() {
        return descriptionField;
    }

    public OfferTable getListTable() {
        return listTable;
    }

    public OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public JCheckBox getReceptionProofField() {
        return receptionProofField;
    }

    public JButton getSendSending() {
        return sendSending;
    }

    public Table getSendingContent() {
        return sendingContent;
    }

    public Session getSession() {
        return session;
    }

    public JLabel getStatusField() {
        return statusField;
    }

    public JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Sending bean) {
        Sending oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setSession(Session session) {
        Session oldValue = this.session;
        this.session = session;
        firePropertyChange(PROPERTY_SESSION, oldValue, session);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSendingContent() {
        if (!allComponentsCreated) {
            return;
        }
        sendingContent.add($Table1, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        sendingContent.add($Table2, new GridBagConstraints(0, 1, 1, 1, 0.8, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDescriptionField() {
        $objectMap.put("descriptionField", descriptionField = new JTextArea());
        
        descriptionField.setName("descriptionField");
        descriptionField.setColumns(15);
        descriptionField.setLineWrap(true);
        descriptionField.setWrapStyleWord(true);
        descriptionField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__descriptionField"));
        descriptionField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descriptionField"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new OfferTable());
        
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = new OfferListColumnFactory());
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = new OfferListTableModel(true));
    }

    protected void createReceptionProofField() {
        $objectMap.put("receptionProofField", receptionProofField = new JCheckBox());
        
        receptionProofField.setName("receptionProofField");
        receptionProofField.setText(_("vradi.email.receptionProof"));
        receptionProofField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receptionProofField"));
    }

    protected void createSendSending() {
        $objectMap.put("sendSending", sendSending = new JButton());
        
        sendSending.setName("sendSending");
        sendSending.setText(_("vradi.email.sendSending"));
        sendSending.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sendSending"));
    }

    protected void createSendingContent() {
        $objectMap.put("sendingContent", sendingContent = new Table());
        
        sendingContent.setName("sendingContent");
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createStatusField() {
        $objectMap.put("statusField", statusField = new JLabel());
        
        statusField.setName("statusField");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JLabel());
        
        title.setName("title");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $EmailContentUI0
        add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($Table0, BorderLayout.NORTH);
        $JPanel0.add($JPanel2, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sendSending, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HidorButton0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel2
        $JPanel2.add(sendingContent, BorderLayout.NORTH);
        $JPanel2.add($JScrollPane2, BorderLayout.CENTER);
        addChildrenToSendingContent();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(statusField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(receptionProofField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(descriptionField);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(listTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        title.setText(_(updateTitle()));
        sendSending.setIcon(SwingUtil.getUIManagerActionIcon("send"));
        sendSending.setEnabled(canBeReSend());
        $HidorButton0.setHideTip(_("vradi.email.hideForm"));
        $HidorButton0.setShowTip(_("vradi.email.showForm"));
        $HidorButton0.setTarget(sendingContent);
        $HidorButton0.setTargetVisible(true);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setFillsViewportHeight(true);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$EmailContentUI0", $EmailContentUI0);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createBean();
        createSession();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createTitle();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createSendSending();
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createSendingContent();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.status"));
        createStatusField();
        createReceptionProofField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.paragraph"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createDescriptionField();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_NEVER,                                                 JScrollPane.HORIZONTAL_SCROLLBAR_NEVER));
        
        $JScrollPane2.setName("$JScrollPane2");
        createListTable();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("status", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    statusField.setText(_(VradiConstants.SendingStatus.getStatus(getBean().getStatus()).getDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("status", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEPTION_PROOF_FIELD_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("receptionProof", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    receptionProofField.setSelected(getBean().getReceptionProof());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("receptionProof", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(descriptionField, getBean().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("paragraph", this);
                }
            }
        });
    }

}