/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.beans.QueryBean;
import org.chorem.vradi.ui.admin.AdminHandler;
import static org.nuiton.i18n.I18n._;

public class RequestSelectUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_QUERY_DESCRIPTION_TEXT = "queryDescription.text";
    public static final String BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT = "queryDescription.toolTipText";
    public static final String BINDING_QUERY_NAME_TEXT = "queryName.text";
    public static final String BINDING_QUERY_NAME_TOOL_TIP_TEXT = "queryName.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_TOOL_TIP_TEXT = "$JButton0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(RequestSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected QueryBean bean;
    protected JTextArea queryDescription;
    protected JTextField queryName;
    protected RequestSelectUI requestSelectUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    public void confirmDeletion() {
        org.chorem.vradi.beans.QueryBean queryBean = getBean();
        if (StringUtils.isBlank(queryBean.getName())
                && StringUtils.isBlank(queryBean.getDescription())
                && StringUtils.isBlank(queryBean.getQuery())) {
            setBean(null);
    
        } else {
            int confirm = JOptionPane.showConfirmDialog(this,
                    _("vradi.admin.confirmDelete", VradiHelper.getEntityName(getBean())),
                    _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);
    
            if (confirm == JOptionPane.YES_OPTION) {
                setBean(null);
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestSelectUI() {
        $initialize();
    }

    public RequestSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().openRequest(this, getBean());
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        confirmDeletion();
    }

    public void doKeyReleased__on__queryDescription(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setBean(getBean().setDescription(queryDescription.getText()));
    }

    public void doKeyReleased__on__queryName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setBean(getBean().setName(queryName.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public QueryBean getBean() {
        return bean;
    }

    public JTextArea getQueryDescription() {
        return queryDescription;
    }

    public JTextField getQueryName() {
        return queryName;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(QueryBean bean) {
        QueryBean oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add($JLabel1, new GridBagConstraints(1, 0, 3, 1, 0.7, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add(queryName, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new org.chorem.vradi.beans.QueryBean());
    }

    protected void createQueryDescription() {
        $objectMap.put("queryDescription", queryDescription = new JTextArea());
        
        queryDescription.setName("queryDescription");
        queryDescription.setColumns(15);
        queryDescription.setLineWrap(true);
        queryDescription.setWrapStyleWord(true);
        queryDescription.setRows(2);
        queryDescription.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryDescription"));
    }

    protected void createQueryName() {
        $objectMap.put("queryName", queryName = new JTextField());
        
        queryName.setName("queryName");
        queryName.setColumns(15);
        queryName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryName"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToRequestSelectUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(queryDescription);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("requestSelectUI", requestSelectUI);
        createBean();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.requestSelectUI.name"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.requestSelectUI.description"));
        createQueryName();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createQueryDescription();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.edit"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminRequest.remove"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryName.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(queryName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryDescription.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(queryDescription, getBean().getDescription());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    $JButton0.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
    }

}