/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiContext.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/VradiContext.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.vradi;

import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.ui.VradiMainUI;
import org.chorem.vradi.ui.admin.AdminPopupUI;
import org.chorem.vradi.ui.email.EmailPopupUI;
import org.chorem.vradi.ui.offer.OfferListUI;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.widget.SwingSession;

import java.util.List;
import java.util.Locale;

public class VradiContext extends DefaultApplicationContext {

    static private Log log = LogFactory.getLog(VradiContext.class);

    public static final JAXXContextEntryDef<VradiMainUI> MAIN_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("mainui", VradiMainUI.class);

    public static final JAXXContextEntryDef<OfferListUI> OFFERT_LIST_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("offerList", OfferListUI.class);

    public static final JAXXContextEntryDef<AdminPopupUI> ADMIN_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("adminPopupUI", AdminPopupUI.class);

    public static final JAXXContextEntryDef<EmailPopupUI> EMAIL_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("emailViewUI", EmailPopupUI.class);

    public static final JAXXContextEntryDef<List<Locale>> LOCALES_AVAILABLES =
            SwingUtil.newListContextEntryDef("localesAvailables");

    /** Instance of SwingSession to save ui disposition */
    public static final JAXXContextEntryDef<SwingSession> SWING_SESSION_ENTRY_DEF =
            SwingUtil.newContextEntryDef("swingSession", SwingSession.class);

    /**
     * l'intance partagée accessible après un appel à la méthode
     * {@link #init()}
     */
    protected static VradiContext instance;

    /**
     * @return <code>true</code> si le context a été initialisé via la méthode
     *         {@link #init()}, <ocde>false</code> autrement.
     */
    public static boolean isInit() {
        return instance != null;
    }

    /**
     * Permet l'initialisation du contexte applicatif et positionne
     * l'instance partagée.
     * <p/>
     * Note : Cette méthode ne peut être appelée qu'une seule fois.
     *
     * @return l'instance partagée
     * @throws IllegalStateException si un contexte applicatif a déja été positionné.
     */
    public static synchronized VradiContext init() throws IllegalStateException {
        if (isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        instance = new VradiContext();
        return instance;
    }

    /**
     * Récupération du contexte applicatif.
     *
     * @return l'instance partagé du contexte.
     * @throws IllegalStateException si le contexte n'a pas été initialisé via
     *                               la méthode {@link #init()}
     */
    public static VradiContext get() throws IllegalStateException {
        if (!isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    /** Un objet pour bloquer le context */
    protected final Object lock = new Object();

    protected VradiContext() {
        super();
    }

    public void lock() throws InterruptedException {
        synchronized (lock) {
            lock.wait();
        }
    }

    public void releaseLock() {
        synchronized (lock) {
            lock.notify();
        }
    }

    /**
     * close the application's context.
     *
     * @throws Exception if any pb while closing
     */
    public void close() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("closing context " + this);
        }

        // fermeture du context principal
        clear();
    }

    public ApplicationConfig getVradiConfig() {
        return getContextValue(ApplicationConfig.class);
    }

    /**
     * TODO EC20100515 : explain this code !
     *
     * @return
     */
    public DecoratorProvider getDecoratorProvider() {
        return getContextValue(DecoratorProvider.class);
    }

    /**
     * TODO EC20100515 : explain this code !
     *
     * @return
     */
    public DecoratorProviderListCellRenderer getDecoratorProviderListCellRenderer() {
        return getContextValue(DecoratorProviderListCellRenderer.class);
    }

    public VradiNotifier getVradiNotifier() {
        return getContextValue(VradiNotifier.class);
    }

    public List<Locale> getLocalesAvailables() {
        return LOCALES_AVAILABLES.getContextValue(this);
    }

    public void setLocalesAvailables(List<Locale> localesAvailables) {
        LOCALES_AVAILABLES.setContextValue(this, localesAvailables);
    }
}
