/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.helpers;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyExtension;

public class VradiComparators {
    public static final Comparator<Form> FORM_COMPARATOR = new BusinessEntityComparator<Form>("Infogene", "objet");
    public static final Comparator<Client> CLIENT_COMPARATOR = new BusinessEntityComparator<Client>("Client", "name");
    public static final Comparator<Group> GROUP_COMPARATOR = new BusinessEntityComparator<Group>("Group", "name");
    public static final Comparator<Status> STATUSES_COMPARATOR = new BusinessEntityComparator<Status>("Status", "value");
    public static final Comparator<XmlStream> XML_STREAM_COMPARATOR = new BusinessEntityComparator<XmlStream>("XmlStream", "name");
    public static final Comparator<WikittyExtension> EXTENSION_COMPARATOR = new Comparator<WikittyExtension>(){

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            if (o1 != null && o2 != null) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                if (name1 != null) {
                    return 1;
                }
                if (name2 != null) {
                    return -1;
                }
            } else {
                if (o1 != null) {
                    return 1;
                }
                if (o2 != null) {
                    return -1;
                }
            }
            return 0;
        }
    };
    public static final Comparator<User> USER_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User o1, User o2) {
            if (o1 != null && o2 != null) {
                WikittyProxy proxy = VradiService.getWikittyProxy();
                Client client1 = (Client)proxy.restore(Client.class, o1.getClient());
                Client client2 = (Client)proxy.restore(Client.class, o2.getClient());
                String name1 = client1.getName() + ":" + o1.getName();
                String name2 = client2.getName() + ":" + o2.getName();
                return name1.compareToIgnoreCase(name2);
            }
            if (o1 != null) {
                return 1;
            }
            if (o2 != null) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<User> USER_COMPARATOR_WITH_ALL_CLIENT_LOADED = new UserComparator();
    public static final Comparator<Thesaurus> THESAURUS_NAME_PATH_COMPARATOR = new Comparator<Thesaurus>(){

        @Override
        public int compare(Thesaurus o1, Thesaurus o2) {
            return ThesaurusDataHelper.getNamePath(o1, "/").compareTo(ThesaurusDataHelper.getNamePath(o2, "/"));
        }
    };
    public static final Comparator<Thesaurus> THESAURUS_COMPARATOR = new Comparator<Thesaurus>(){

        @Override
        public int compare(Thesaurus o1, Thesaurus o2) {
            int result = 0;
            if (o1 != null && o2 != null) {
                String orderName1 = ThesaurusDataHelper.concateOrderName(o1);
                String orderName2 = ThesaurusDataHelper.concateOrderName(o2);
                return orderName1.compareToIgnoreCase(orderName2);
            }
            return result;
        }
    };
    public static final Comparator<RootThesaurus> ROOT_THESAURUS_COMPARATOR = new Comparator<RootThesaurus>(){

        @Override
        public int compare(RootThesaurus o1, RootThesaurus o2) {
            int result = 0;
            if (o1 != null && o2 != null) {
                result = o1.getName().compareToIgnoreCase(o2.getName());
            }
            return result;
        }
    };

    public static class UserComparator
    implements Comparator<User> {
        protected Map<String, Client> clientsLoaded = new HashMap<String, Client>();

        public UserComparator() {
            this.loadClient(VradiService.getVradiDataService().findAllClients());
        }

        public UserComparator(List<Client> clientsLoad) {
            this.loadClient(clientsLoad);
        }

        protected void loadClient(List<Client> clients) {
            for (Client client : clients) {
                this.clientsLoaded.put(client.getWikittyId(), client);
            }
        }

        @Override
        public int compare(User o1, User o2) {
            if (o1 != null && o2 != null) {
                Client client1 = this.clientsLoaded.get(o1.getClient());
                Client client2 = this.clientsLoaded.get(o2.getClient());
                String name1 = client1.getName() + ":" + o1.getName();
                String name2 = client2.getName() + ":" + o2.getName();
                return name1.compareToIgnoreCase(name2);
            }
            if (o1 != null) {
                return 1;
            }
            if (o2 != null) {
                return -1;
            }
            return 0;
        }
    }

    public static class BusinessEntityComparator<T extends BusinessEntity>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final String extension;
        final String field;

        public BusinessEntityComparator(String extension, String field) {
            this.extension = extension;
            this.field = field;
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 != null && o2 != null) {
                Object name1 = o1.getField(this.extension, this.field);
                Object name2 = o2.getField(this.extension, this.field);
                if (name1 != null && name2 != null) {
                    String string1 = WikittyUtil.toString((Object)name1);
                    String string2 = WikittyUtil.toString((Object)name2);
                    return string1.compareToIgnoreCase(string2);
                }
                if (name1 != null) {
                    return 1;
                }
                if (name2 != null) {
                    return -1;
                }
            } else {
                if (o1 != null) {
                    return 1;
                }
                if (o2 != null) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

